# -*- coding: utf-8 -*-
import re
import socket

import yenv


HOST_GEO_RE = re.compile(r'^[^\.]+?-(?P<geo>\w)\d+\.')
HOST_GEO_MAPPING = {
    'f': 'man',
    'i': 'iva',
    'm': 'myt',
    's': 'sas',
    'v': 'vla',
}


def get_current_dc(default='none'):
    result = ''
    fqdn = socket.getfqdn()
    match = HOST_GEO_RE.match(fqdn)
    if match:
        result = HOST_GEO_MAPPING.get(match.group('geo').lower(), '')
    return result or default


def get_current_env_type():
    return yenv.type
