# -*- coding: utf-8 -*-
from contextlib import contextmanager


@contextmanager
def unsafe(valid_exceptions=None):
    """
    Выполняет код и подавляет исключения.
    Если передан параметр valid_exceptions, то пропускает только исключения из списка.
    """
    result = dict(
        status=None,
        exception=None,
    )
    try:
        yield result
        result['status'] = True
    except Exception as e:
        result['status'] = False
        result['exception'] = e
        if valid_exceptions is None:
            return
        for x in valid_exceptions:
            if isinstance(e, x):
                return
        raise
