# -*- coding: utf-8 -*-
from __future__ import absolute_import

import itertools
import random


# Поделить iterable на чанки размером n, также являющийся настоящим итератором
def ichunks(n, iterable):
    it = iter(iterable)
    while True:
        chunk = tuple(itertools.islice(it, n))
        if not chunk:
            return
        yield chunk


def ireplacer(column, value, iterable):
    for item in iterable:
        item[column] = value(item[column]) if hasattr(value, '__call__') else value
        yield item


# Выполнить весь код итератора до первого yield сразу же, а не после начала итерирования
def inow(iterable):
    try:
        rows = iter(iterable)
        item = next(rows)
        return itertools.chain([item], rows)
    except StopIteration:
        return iter(())


# Выполнить функцию, возвращающую итератор не сразу, а после начала итерирования
def idelayed(func, *args, **kwargs):
    rows = func(*args, **kwargs)
    for row in rows:
        yield row


def imemoizer(column, storage, iterable):
    for item in iterable:
        storage.add(item.get(column))
        yield item


def idropout(probability, iterable):
    for item in iterable:
        if random.random() < probability:
            yield item


def chunks(n, arr):
    for i in range(0, len(arr), n):
        yield arr[i:i + n]


class RewindableIterator(object):
    """
    Итератор, позволяющий перезапускать итерацию.
    """
    def __init__(self, iterable):
        self.iterator = iter(iterable)
        self.memorized_iter = None
        self.memorized_items = []

    def __iter__(self):
        return self

    def next(self):
        if self.memorized_iter is not None:
            try:
                return next(self.memorized_iter)
            except StopIteration:
                self.memorized_iter = None

        item = next(self.iterator)
        self.memorized_items.append(item)
        return item

    def rewind(self):
        self.memorized_iter = iter(self.memorized_items)
