# -*- coding: utf-8 -*-
from __future__ import absolute_import

import math
import operator

from six.moves import reduce


def logit(value):
    if value <= 0.0 or value >= 1.0:
        raise ValueError('Expected float in range (0.0, 1.0)')
    return math.log(value / (1.0 - value), math.e)


def safe_int64_cast(x):
    try:
        r = int(x)
        if r.bit_length() <= 64:
            return r
        else:
            return None
    except Exception:
        return None


def sequence_multiply(value):
    return reduce(operator.mul, value, 1)


def sigmoid(z):
    s = 1.0 / (1.0 + math.exp(-z))
    return s
