import random

import phonenumbers
from phonenumbers.phonenumberutil import region_code_for_number


def get_country_by_phone_number(phone_number):
    if phone_number is None:
        return None
    region = region_code_for_number(phonenumbers.parse('+' + phone_number))
    return region.lower() if region else None


def random_phone_number():
    return '+7000' + ''.join(str(random.randint(0, 9)) for _ in range(7))


def compare_phone_numbers(phone1, phone2):
    try:
        parsed_1 = phonenumbers.parse(phone1, region='ru')
    except phonenumbers.NumberParseException as err:
        raise ValueError('Unparsable phone number 1 {}: {}'.format(phone1, err))
    try:
        parsed_2 = phonenumbers.parse(phone2, region='ru')
    except phonenumbers.NumberParseException as err:
        raise ValueError('Unparsable phone number 2 {}: {}'.format(phone2, err))
    return parsed_1 == parsed_2
