from passport.backend.utils.ccffi cimport ccffi


cdef extern from "openssl/ssl.h":
    """
    typedef STACK_OF(X509) STACK_OF_X509;
    """

    const int PKCS7_NOINTERN
    const int PKCS7_NOVERIFY

    ctypedef struct BIO:
        pass

    ctypedef struct EC_KEY:
        pass

    ctypedef struct EVP_PKEY:
        pass

    ctypedef struct PKCS7:
        pass

    ctypedef struct STACK_OF_X509:
        pass

    ctypedef struct X509:
        pass

    ctypedef struct X509_STORE:
        pass

    int BIO_free(BIO* a)
    BIO* BIO_new_mem_buf(const void* buf, int len)
    PKCS7* d2i_PKCS7_bio(BIO* bp, PKCS7** a)
    int EC_KEY_up_ref(EC_KEY* key)
    void* EVP_PKEY_get0(const EVP_PKEY* pkey)
    void PKCS7_free(PKCS7* a)
    int PKCS7_verify(
        PKCS7* p7,
        STACK_OF_X509* certs,
        X509_STORE* store,
        BIO* indata,
        BIO* out,
        int flags,
    )
    void sk_X509_free(const STACK_OF_X509* sk)
    STACK_OF_X509* sk_X509_new_null()
    int sk_X509_push(STACK_OF_X509* sk, const X509* ptr)


cdef extern from "openssl/err.h":
    void ERR_error_string_n(unsigned long e, char* buf, size_t len)
    unsigned long ERR_get_error()


cdef:
    enum:
        ERR_MSG_LEN = 256


def pkcs7_verify(
    data,
    signature,
    Certificates certificates,
):
    cdef:
        BIO* data_bio = NULL
        char* data_buf = data
        PKCS7* p7 = NULL
        BIO* signa_bio = NULL
        char* signa_buf = signature

    try:
        signa_bio = BIO_new_mem_buf(signa_buf, len(signature))
        if signa_bio == NULL:
            raise Pkcs7VerifyError(_get_last_error())

        if d2i_PKCS7_bio(signa_bio, &p7) == NULL:
            raise Pkcs7VerifyError(_get_last_error())

        data_bio = BIO_new_mem_buf(data_buf, len(data))
        if data_bio == NULL:
            raise Pkcs7VerifyError(_get_last_error())

        if PKCS7_verify(
            p7=p7,
            certs=certificates._x509s,
            store=NULL,
            indata=data_bio,
            out=NULL,
            flags=PKCS7_NOINTERN | PKCS7_NOVERIFY,
        ) == 0:
            raise InvalidSignature(_get_last_error())
    finally:
        if p7 != NULL:
            PKCS7_free(p7)
        if data_bio != NULL:
            BIO_free(data_bio)
        if signa_bio != NULL:
            BIO_free(signa_bio)


cdef object _get_last_error():
    cdef char err_msg[ERR_MSG_LEN]
    ERR_error_string_n(ERR_get_error(), err_msg, ERR_MSG_LEN)
    return err_msg


cdef class Certificates:
    cdef:
        STACK_OF_X509* _x509s
        list _certs

    def __cinit__(self):
        self._x509s = sk_X509_new_null()
        if self._x509s == NULL:
            raise Pkcs7VerifyError(_get_last_error())
        self._certs = list()

    def __dealloc__(self):
        if self._x509s != NULL:
            sk_X509_free(self._x509s)

    def push(self, certificate):
        if sk_X509_push(self._x509s, <X509*>ccffi.from_ffi_addr(certificate._x509)) == 0:
            raise Pkcs7VerifyError(_get_last_error())
        self._certs.append(certificate)


class Pkcs7VerifyError(Exception):
    pass


class InvalidSignature(Pkcs7VerifyError):
    pass
