# -*- coding: utf-8 -*-
import subprocess

from setuptools import (
    find_packages,
    setup,
)
from setuptools.command.install_lib import install_lib as InstallLibOrig


PREFIX = 'passport_backend_utils'
PROJECT_ROOT = '..'


# FIXME: оторвать костыли по патчингу импортов после перехода на py3-only или
#  иного решения проблемы в https://st.yandex-team.ru/PYTHONCOM-255
class InstallLib(InstallLibOrig):
    def build(self):
        p = subprocess.Popen(['./patch_imports.sh', PROJECT_ROOT], cwd='.', shell=False, stdout=subprocess.PIPE)
        for line in iter(p.stdout.readline, b''):
            print(line.rstrip())
        InstallLibOrig.build(self)


setup(
    name='yandex-passport-python-utils',
    version='1.0.0',
    description='Common python utils',
    url='https://a.yandex-team.ru/arc/trunk/arcadia/passport/backend/utils',
    author='Passport team',
    author_email='passport-dev@yandex-team.ru',
    package_dir={PREFIX: PROJECT_ROOT},
    packages=[
        '.'.join([PREFIX, package])
        for package in (find_packages(PROJECT_ROOT, exclude=['tests']) + [''])
    ],
    package_data={
        '': [
            'patch_imports.sh',
        ],
    },
    install_requires=[
        'Jinja2',
        'mock',
        'pytz',
        'six',
        'yenv',
        'ylock',
    ],
    cmdclass={
        'install_lib': InstallLib,
    },
)
