# -*- coding: utf-8 -*-
from datetime import timedelta

from passport.backend.utils.time import to_date_str
from statface_client import (
    constants,
    StatfaceClient as NativeStatfaceClient,
)
from statface_client.base_client import BaseStatfaceClient
from statface_client.report import StatfaceReportAPI


def get_report_api(nile_statbox_client, report_path):
    native_client = NativeStatfaceClient(
        host=nile_statbox_client.proxy,
        username=nile_statbox_client.username,
        password=nile_statbox_client.password,
    )

    native_report_api = StatfaceReportAPI(native_client, report_path)

    return native_report_api


def add_graphs(client, report_path, graphs):
    report_api = get_report_api(client, report_path)
    config = report_api.download_config()
    config[u'graphs'] = graphs
    config[u'user_config'][u'graphs'] = graphs
    return report_api.upload_config(config)


def publish(client, report):

    if report._path is None or report._scale is None or report._data is None:
        raise ValueError(
            'Report for publication must have defined path, scale and data',
        )

    native_report_api = get_report_api(client, report._path)

    if report.statface_config:
        native_report_api.upload_config(
            config=report.statface_config,
            overwrite=True,
        )

    replace_mask = report.replace_fields
    chunks = client._prepare_data(report._data, replace_mask)

    for chunk in chunks:
        native_report_api.upload_data(
            scale=report._scale,
            data=chunk,
            format=constants.JSON_DATA_FORMAT,
            replace_mask=['fielddate', 'condition', 'changed_1', 'not_changed_1', 'changed_7', 'not_changed_7'],
        )


def get_missing_dates(client, name, scale, date_min, date_max, distance_day=None):
    # ждём STATINFRA-7884
    entry_point = '_api/report/missing_dates'
    native_client = BaseStatfaceClient(
        host=client.proxy,
        username=client.username,
        password=client.password,
    )
    request_data = {
        'name': name,
        'scale': scale,
        'date_min': date_min,
        'date_max': date_max,
        'distance_day': distance_day,  # не знаю что это, на вид вообще не влияет ни на что
    }
    response = native_client._request('GET', entry_point, params=request_data)
    return response.json()


def is_exist(client, name):
    # ждём STATINFRA-7884
    entry_point = '_api/report/config'
    native_client = BaseStatfaceClient(
        host=client.proxy,
        username=client.username,
        password=client.password,
    )
    request_data = {
        'name': name,
    }
    try:
        native_client._request('GET', entry_point, params=request_data)
        return True
    except Exception:
        return False


def is_report_uploaded_to_statface(client, name, date, scale):
    # Беру по месяцу + 1 вокруг запрошенной даты, потому что scale > 'm' мы не пользуемся
    # Должно хватить
    date_min, date_max = date - timedelta(days=32), date + timedelta(days=32)
    # missing_dates содержит начала (множ. число) периодов
    # для недель это даты понедельников, для месяцев - первые числа, для дней - просто перечень дней
    try:
        missing_dates = get_missing_dates(client, name, scale, date_min, date_max)
    except Exception:
        return False
    if 'missing' not in missing_dates:
        return False
    if scale == 'w':
        start_date = date - timedelta(days=date.weekday())  # дата понедельника
    elif scale == 'm':
        start_date = date.replace(day=1)  # первое число - начало месяца
    elif scale == 'd':
        start_date = date
    else:
        raise ValueError("Unexpected scale value %r" % (scale,))
    already_uploaded_to_statface = to_date_str(start_date) not in missing_dates['missing']
    return already_uploaded_to_statface


def is_report_calculated_for_field(client, name, date, field):
    src_report = client.get_report(name)
    old_records = src_report.download_data('daily', date_min=to_date_str(date), date_max=to_date_str(date))
    for old_one in old_records:
        if old_one.get(field) is None or len(old_one[field]) == 0:
            return False
    return True
