import subprocess


class RunCommandException(Exception):
    def __init__(self, out, err, code, *args):
        super(RunCommandException, self).__init__(*args)
        self.code = code
        self.out = out
        self.err = err

    def __repr__(self):
        return '%s\nCode: %s\nStdout: %s\nStderr: %s' % (
            super(RunCommandException, self).__repr__(),
            self.code,
            self.out,
            self.err,
        )

    def __str__(self):
        return self.__repr__()


def run_command(command, valid_codes=(0,)):
    proc = subprocess.Popen(
        command,
        stdout=subprocess.PIPE,
        stderr=subprocess.PIPE,
        shell=True,
    )
    out, err = proc.communicate()
    if proc.returncode not in valid_codes:
        raise RunCommandException(
            out.decode('utf-8').strip() if out else None,
            err.decode('utf-8').strip() if err else None,
            proc.returncode,
        )
    return out.decode('utf-8').strip()
