# -*- coding: utf-8 -*-

from os.path import basename as path_basename

from jinja2.loaders import (
    DictLoader,
    FileSystemLoader,
)


class CachedTemplateLoader(DictLoader):
    """
    Объединяет свойства FileSystemLoader & DictLoader
    Принимает имена директории для загрузки всех файлов из них как шаблонов;
    Сохраняет только содержимое шаблонов в памяти
    """

    def __init__(self, searchpath, encoding='utf-8'):
        template_map = {}
        template_names = []

        try:
            from passport.backend.utils.file import list_resources, read_file
            for name in list_resources():
                if name.startswith('templates/'):
                    # Удаляем из названия папку с шаблонами вместе со слешом
                    template_map[name[(len('templates/')):]] = read_file(name, encoding=encoding)
        except ImportError:
            file_loader = FileSystemLoader(searchpath, encoding=encoding)

            for name in file_loader.list_templates():
                if not path_basename(name).startswith('.'):
                    template_names.append(name)

            for template_name in template_names:
                content, _, _ = file_loader.get_source(environment={}, template=template_name)
                template_map[template_name] = content

        super(CachedTemplateLoader, self).__init__(template_map)
