import sys

import pytz
import six
from yt.wrapper import TablePath


moscow_zone = pytz.timezone('Europe/Moscow')
yql_types = {
    float: 'double',
    str: 'string',
    bool: 'boolean',
    list: 'any',
    type(None): None,
}
for type_ in six.integer_types:
    yql_types[type_] = 'int64'


def derive_yql_types(name, yt, limit=sys.maxint):
    key_columns = yt.get_attribute(name, 'key_columns')
    key_types = {}
    col_types = {}
    for row in yt.read_table(TablePath(name, end_index=limit, client=yt)):
        for key, value in row.items():
            col_types[key] = yql_types[value.__class__] or col_types.get(key)
    for key in col_types.keys():
        if col_types[key] is None:
            del col_types[key]
        elif key in key_columns:
            key_types[key] = col_types[key]
            del col_types[key]
    return key_types.items(), col_types.items()


def yt_ensure(yt, *dirs):
    for d in dirs:
        if not yt.exists(d):
            yt.mkdir(d, recursive=True)
