# coding: utf-8

from imp import load_source
import os

from passport.backend.core.lazy_loader import LazyLoader
from passport.backend.library.configurator import Configurator
from passport.backend.vault.api.db import SQLAlchemy
from passport.backend.vault.api.dynamic_settings import get_dynamic_settings
from ticket_parser2 import BlackboxEnv
import yenv


IS_UNDER_TESTS = os.environ.get('YA_TEST_RUNNER')


try:
    secret_settings = load_source('secret_settings', '/usr/lib/yandex/passport-vault-secrets/secret_settings.py')
except IOError:
    from passport.backend.vault.api import default_secret_settings as secret_settings


CURRENT_ENVIRONMENT = 'development' if IS_UNDER_TESTS else yenv.type


LazyLoader.register(
    'config',
    Configurator,
    name='passport-vault',
    configs=[
        {
            'blackbox': dict([(e.name, e.value) for e in BlackboxEnv]),
        },
        secret_settings,
        'base.yaml',
        '%s.yaml' % CURRENT_ENVIRONMENT,
        'logging.yaml',
        'export.yaml',
        get_dynamic_settings,
        'flask.yaml',
    ],
)


def get_config():
    return LazyLoader.get_instance('config')


config = get_config()
config.set_logging()
config.set_as_passport_settings()
LazyLoader.register('db', SQLAlchemy, config=config)
