# coding: utf-8

from flask import request
from passport.backend.core.logging_utils.loggers.graphite import (
    GraphiteLogEntry,
    GraphiteLogger,
)


class VaultGraphiteLogEntry(GraphiteLogEntry):
    """
    GraphiteLogger сам формирует строку для записи лога
    и для него не срабатывает фильтр логера, поэтому обогащаем
    Графитный лог сами
    """

    def __init__(self, **params):
        if request:
            params.setdefault('request_id', request.request_id)
            params.setdefault('request_user_agent', request.real_user_agent)
            params.setdefault('request_user_ip', request.user_ip)
            params.setdefault('request_path', request.full_path)
            params.setdefault('request_method', request.method)
            if hasattr(request, 'remote_ip'):
                params.setdefault('request_remote_ip', request.remote_ip)

        super(VaultGraphiteLogEntry, self).__init__(**params)


class VaultGraphiteLogger(GraphiteLogger):
    entry_class = VaultGraphiteLogEntry
