# coding: utf-8

from datetime import datetime
import getpass
import os
import socket


def get_user_login():
    return os.environ.get('SUDO_USER') or getpass.getuser()


def get_fqdn():
    return socket.getfqdn()


def format_timestamp(ts):
    if not ts:
        return ''
    dt = datetime.fromtimestamp(ts)
    return dt.strftime('%Y-%m-%d %H:%M:%S')


def format_tvm_app(tvm_app):
    if not tvm_app:
        return u'-'

    abc = tvm_app.abc_department
    return u'{app.name} ({abc_name})'.format(
        app=tvm_app,
        abc_name=abc.display_name if abc else u'-',
    )
