# coding: utf-8

import click
from flask.cli import (
    AppGroup,
    with_appcontext,
)
from passport.backend.vault.api.db import get_db
from passport.backend.vault.api.models import (
    DbPoolUpdates,
    SecretVersion,
)


def create_service_cli(app, config):
    service_cli = AppGroup('service', help='Service commands')

    @service_cli.command()
    @with_appcontext
    @click.argument('version_uuid')
    def repair(version_uuid):
        """Fix broken keys column in secret version"""
        version = SecretVersion.get_by_id(version_uuid)
        version.set_keys_from_value(version.value)
        get_db().session.commit()

    @service_cli.command('db_pool_update')
    @with_appcontext
    def db_pool_update():
        """Update the db_poll_updates table"""
        DbPoolUpdates.update_pool()

    return service_cli
