#!/usr/bin/env python

# Provides : push-client-running

import json
import os
import re
import subprocess
import sys


CHECK_PREFIX = 'PASSIVE-CHECK:push-client-running;'


def get_status(config_path):
    prepared_cmd_line = 'push-client --status --json -c {}'.format(config_path)
    result = {}
    try:
        result['output'] = subprocess.check_output(
            prepared_cmd_line,
            stderr=subprocess.STDOUT,
            shell=True,
        )
        result['code'] = 0
    except subprocess.CalledProcessError as e:
        result['output'] = e.output
        result['code'] = e.returncode
    return result


def main():
    result = ''
    configs_list = sys.argv[1:]
    path_prefix = os.environ.get('BSCONFIG_IDIR', '')
    if len(configs_list) == 0:
        print '{}2;No configs specified for check'.format(CHECK_PREFIX)
        sys.exit(0)

    for config_path in configs_list:
        full_path = ''
        if re.match('/', config_path):
            full_path = config_path
        else:
            full_path = path_prefix + '/' + config_path

        raw_status = get_status(full_path)
        try:
            json.loads(raw_status['output'])
        except:
            if re.search('unable to establish connection', raw_status['output']):
                result += 'Push-client with config \'{}\' is not running yet;'.format(config_path)
            else:
                result += 'Unknown exception. Raw status is \'{}\'. Return code: {}'.format(
                    raw_status['output'],
                    raw_status['code'],
                )

    if result == '':
        print '{}0;OK'.format(CHECK_PREFIX)
    else:
        print '{}2;{}'.format(CHECK_PREFIX, result)


if __name__ == '__main__':
    main()
