import os
import socket
import sys

from passport.backend.utils.file import read_file
import yenv


ENV_BOOLEAN_TRUE_STRINGS = ('true', 'on', 'ok', 'y', 'yes', '1')
TEST = os.environ.get('TEST', 'false') in ENV_BOOLEAN_TRUE_STRINGS
USE_LOCAL_MYSQL = os.environ.get('USE_LOCAL_MYSQL', 'false') in ENV_BOOLEAN_TRUE_STRINGS


def keys(context):
    lines = read_file(context['application']['keys_file']).split('\n')
    keys = list(map(lambda x: x.strip().split(' '), filter(lambda x: len(x) > 0, lines)))
    return keys


def migrations_dir(context):
    DEV_PATH = os.path.abspath(os.path.dirname(sys.argv[0]))
    prefix = os.path.join(*os.path.split(DEV_PATH)[:-1])
    return os.path.join(prefix, 'migrations')


def current_dc(context):
    dc_by_host = {}
    for dc in context['application']['hosts']:
        for host in context['application']['hosts'][dc]:
            dc_by_host[host] = dc
    return dc_by_host.get(socket.getfqdn(), None)


def get_dynamic_settings(context):
    result = {
        'application': {
            'keys': keys(context),
            'migrations_dir': migrations_dir(context),
            'current_dc': current_dc(context),
        },
        'hostname': socket.getfqdn(),
        'environment': yenv.type,
        'debug': yenv.type == 'development',
    }

    if yenv.type == 'development' and not TEST:
        # Настройки для локального запуска vault_api run development
        if USE_LOCAL_MYSQL:
            result.update({
                'database': {
                    'master': {'url': 'mysql+pymysql://vault-mysql-test:vault-mysql-test-local-pwd@localhost/vault'},
                    'slave': {'url': 'mysql+pymysql://vault-mysql-test:vault-mysql-test-local-pwd@localhost/vault'},
                },
            })
        else:
            DEV_PATH = os.path.abspath(os.path.dirname(sys.argv[0]))
            result.update({
                'database': {
                    'master': {'url': 'sqlite:///' + os.path.join(DEV_PATH, 'vault_development.sqlite')},
                    'slave': {'url': 'sqlite:///' + os.path.join(DEV_PATH, 'vault_development.sqlite')},
                },
            })
        result['application']['balancer'] = 'http://localhost:9500'

    return result
