# -*- coding: utf-8 -*-

"""

Initial database structure.

Revision ID: 928230bf9480
Revises:
Create Date: 2018-06-25 10:33:45.526080

"""
from alembic import op
from passport.backend.vault.api import models
import sqlalchemy as sa


revision = '928230bf9480'
down_revision = None
branch_labels = None
depends_on = None


def upgrade():
    op.create_table(
        'bundles',
        sa.Column('updated_at', models.base.Timestamp(), nullable=False),
        sa.Column('updated_by', models.base.MagicBigInteger(), nullable=False),
        sa.Column('created_at', models.base.Timestamp(), nullable=False),
        sa.Column('created_by', models.base.MagicBigInteger(), nullable=False),
        sa.Column('uuid', models.bundle.BundleUUIDType(), nullable=False),
        sa.Column('name', sa.String(length=255), nullable=True),
        sa.Column('comment', sa.String(length=1023), nullable=True),
        sa.PrimaryKeyConstraint('uuid'),
    )
    op.create_index('idx_bundles_created_at', 'bundles', ['created_at'], unique=False)
    op.create_index('idx_bundles_created_by', 'bundles', ['created_by'], unique=False)
    op.create_index('idx_bundles_updated_at', 'bundles', ['updated_at'], unique=False)
    op.create_index('idx_bundles_updated_by', 'bundles', ['updated_by'], unique=False)

    op.create_table(
        'external_records',
        sa.Column('external_type', models.external_record.ExternalType(length=100), nullable=False),
        sa.Column('external_id', models.base.MagicBigInteger(), nullable=False),
        sa.Column('uid', models.base.MagicBigInteger(), nullable=False),
        sa.Column('login', sa.String(length=255), nullable=True),
        sa.Column('created_at', models.base.Timestamp(), nullable=False),
        sa.PrimaryKeyConstraint('external_type', 'external_id', 'uid'),
    )
    op.create_index('idx_external_records_login', 'external_records', ['login'], unique=False)
    op.create_index('idx_external_records_uid', 'external_records', ['uid'], unique=False)

    op.create_table(
        'secrets',
        sa.Column('updated_at', models.base.Timestamp(), nullable=False),
        sa.Column('updated_by', models.base.MagicBigInteger(), nullable=False),
        sa.Column('created_at', models.base.Timestamp(), nullable=False),
        sa.Column('created_by', models.base.MagicBigInteger(), nullable=False),
        sa.Column('uuid', models.secret.SecretUUIDType(), nullable=False),
        sa.Column('name', sa.String(length=255), nullable=True),
        sa.Column('comment', sa.String(length=1023), nullable=True),
        sa.PrimaryKeyConstraint('uuid'),
    )
    op.create_index('idx_secrets_created_at', 'secrets', ['created_at'], unique=False)
    op.create_index('idx_secrets_created_by', 'secrets', ['created_by'], unique=False)
    op.create_index('idx_secrets_updated_at', 'secrets', ['updated_at'], unique=False)
    op.create_index('idx_secrets_updated_by', 'secrets', ['updated_by'], unique=False)

    op.create_table(
        'tags',
        sa.Column('tag_id', models.base.UUIDType(), nullable=False),
        sa.Column('title', models.tags.TagTitle(length=127), nullable=False),
        sa.Column('created_at', models.base.Timestamp(), nullable=False),
        sa.Column('created_by', models.base.MagicBigInteger(), nullable=False),
        sa.PrimaryKeyConstraint('tag_id'),
        sa.UniqueConstraint('title'),
    )
    op.create_table(
        'user_info',
        sa.Column('uid', models.base.MagicBigInteger(), nullable=False, autoincrement=False),
        sa.Column('login', sa.String(length=255), nullable=True),
        sa.Column('keys', models.base.MagicJSON(), nullable=True),
        sa.Column('first_name', sa.String(length=255), nullable=True),
        sa.Column('last_name', sa.String(length=255), nullable=True),
        sa.Column('created_at', models.base.Timestamp(), nullable=False),
        sa.PrimaryKeyConstraint('uid'),
    )
    op.create_index('idx_user_info_login', 'user_info', ['login'], unique=False)
    op.create_index('idx_user_info_first_name', 'user_info', ['first_name'], unique=False)
    op.create_index('idx_user_info_last_name', 'user_info', ['last_name'], unique=False)

    op.create_table(
        'bundle_versions',
        sa.Column('created_at', models.base.Timestamp(), nullable=False),
        sa.Column('created_by', models.base.MagicBigInteger(), nullable=False),
        sa.Column('version', models.bundle_version.BundleVersionUUIDType(), nullable=False),
        sa.Column('bundle_uuid', models.bundle.BundleUUIDType(), nullable=False),
        sa.Column('comment', sa.String(length=1023), nullable=True),
        sa.ForeignKeyConstraint(['bundle_uuid'], [u'bundles.uuid'], name='bundle_versions_ibfk_1'),
        sa.PrimaryKeyConstraint('version'),
    )
    op.create_index('idx_bundle_versions_bundle_uuid', 'bundle_versions', ['bundle_uuid'], unique=False)
    op.create_index('idx_bundle_versions_created_at', 'bundle_versions', ['created_at'], unique=False)
    op.create_index('idx_bundle_versions_created_by', 'bundle_versions', ['created_by'], unique=False)

    op.create_table(
        'delegation_tokens',
        sa.Column('id', models.delegation_token.DelegationTokenUUIDType(), nullable=False),
        sa.Column('hashed_token', sa.String(length=128), nullable=True),
        sa.Column('secret_uuid', models.secret.SecretUUIDType(), nullable=False),
        sa.Column('tvm_client_id', models.base.MagicBigInteger(), nullable=True),
        sa.Column('signature', sa.String(length=128), nullable=True),
        sa.Column('created_by', models.base.MagicBigInteger(), nullable=True),
        sa.Column('created_at', models.base.Timestamp(), nullable=False),
        sa.ForeignKeyConstraint(['secret_uuid'], [u'secrets.uuid'], name='delegation_tokens_ibfk_1'),
        sa.PrimaryKeyConstraint('id'),
        sa.UniqueConstraint('hashed_token'),
    )
    op.create_index('idx_delegation_tokens_created_at', 'delegation_tokens', ['created_at'], unique=False)
    op.create_index('idx_delegation_tokens_created_by', 'delegation_tokens', ['created_by'], unique=False)
    op.create_index('idx_delegation_tokens_secret_uuid', 'delegation_tokens', ['secret_uuid'], unique=False)

    op.create_table(
        'secret_versions',
        sa.Column('created_at', models.base.Timestamp(), nullable=False),
        sa.Column('created_by', models.base.MagicBigInteger(), nullable=False),
        sa.Column('version', models.secret_version.SecretVersionUUIDType(), nullable=False),
        sa.Column('secret_uuid', models.secret.SecretUUIDType(), nullable=False),
        sa.Column('parent_version_uuid', models.secret_version.SecretVersionUUIDType(), nullable=True),
        sa.Column('cipher_key_id', sa.String(length=32), nullable=False),
        sa.Column('value', models.base.MagicBLOB(), nullable=False),
        sa.Column('comment', sa.String(length=1023), nullable=True),
        sa.Column('keys', sa.String(length=1023), nullable=True),
        sa.ForeignKeyConstraint(['secret_uuid'], [u'secrets.uuid'], name='secret_versions_ibfk_1'),
        sa.PrimaryKeyConstraint('version'),
    )
    op.create_index('idx_secret_versions_created_at', 'secret_versions', ['created_at'], unique=False)
    op.create_index('idx_secret_versions_created_by', 'secret_versions', ['created_by'], unique=False)
    op.create_index('idx_secret_versions_secret_uuid', 'secret_versions', ['secret_uuid'], unique=False)

    op.create_table(
        'tags_entities',
        sa.Column('tag_id', models.base.UUIDType(), nullable=False),
        sa.Column('entity_type_id', models.base.MagicInteger(), nullable=False),
        sa.Column('entity_id', models.base.UUIDType(), nullable=False),
        sa.Column('created_at', models.base.Timestamp(), nullable=False),
        sa.Column('created_by', models.base.MagicBigInteger(), nullable=False),
        sa.ForeignKeyConstraint(['tag_id'], [u'tags.tag_id'], name='tags_entities_ibfk_1'),
        sa.PrimaryKeyConstraint('tag_id', 'entity_type_id', 'entity_id'),
    )
    op.create_index('idx_tags_entities_entity_type_id_tag_id', 'tags_entities', ['entity_type_id', 'tag_id'], unique=False)

    op.create_table(
        'user_roles',
        sa.Column('id', models.base.UUIDType(), nullable=False),
        sa.Column('uid', models.base.MagicBigInteger(), nullable=True),
        sa.Column('role_id', models.base.MagicInteger(), nullable=False),
        sa.Column('abc_id', models.base.MagicBigInteger(), nullable=True),
        sa.Column('staff_id', models.base.MagicBigInteger(), nullable=True),
        sa.Column('secret_uuid', models.secret.SecretUUIDType(), nullable=True),
        sa.Column('bundle_uuid', models.bundle.BundleUUIDType(), nullable=True),
        sa.Column('created_at', models.base.Timestamp(), nullable=False),
        sa.Column('created_by', models.base.MagicBigInteger(), nullable=False),
        sa.Column('__uniq_key_string__', sa.CHAR(length=32), nullable=False),
        sa.ForeignKeyConstraint(['bundle_uuid'], [u'bundles.uuid'], name='user_roles_ibfk_2'),
        sa.ForeignKeyConstraint(['secret_uuid'], [u'secrets.uuid'], name='user_roles_ibfk_1'),
        sa.PrimaryKeyConstraint('id'),
        sa.UniqueConstraint('role_id', '__uniq_key_string__', name='user_roles_uq_1'),
    )
    op.create_index('idx_user_roles_abc_id', 'user_roles', ['abc_id'], unique=False)
    op.create_index('idx_user_roles_bundle_uuid', 'user_roles', ['bundle_uuid', 'role_id'], unique=False)
    op.create_index('idx_user_roles_secret_uuid', 'user_roles', ['secret_uuid', 'role_id'], unique=False)
    op.create_index('idx_user_roles_staff_id', 'user_roles', ['staff_id'], unique=False)
    op.create_index('idx_user_roles_uid', 'user_roles', ['uid'], unique=False)

    op.create_table(
        'bundle_version_to_secret_version',
        sa.Column('bundle_version', models.bundle_version.BundleVersionUUIDType(), nullable=False),
        sa.Column('secret_version', models.secret_version.SecretVersionUUIDType(), nullable=False),
        sa.ForeignKeyConstraint(['bundle_version'], ['bundle_versions.version'], name='bundle_version_to_secret_version_ibfk_1'),
        sa.ForeignKeyConstraint(['secret_version'], ['secret_versions.version'], name='bundle_version_to_secret_version_ibfk_2'),
        sa.PrimaryKeyConstraint('bundle_version', 'secret_version'),
    )

    op.create_table(
        'abc_department_info',
        sa.Column('id', models.base.MagicBigInteger(), nullable=False, autoincrement=False),
        sa.Column('unique_name', sa.String(length=255), nullable=True),
        sa.Column('display_name', sa.String(length=255), nullable=True),
        sa.Column('created_at', models.base.Timestamp(), nullable=False),
        sa.PrimaryKeyConstraint('id'),
    )
    op.create_index('idx_abc_department_info_login', 'abc_department_info', ['unique_name'], unique=False)
    op.create_index('idx_abc_department_info_unique_name', 'abc_department_info', ['unique_name'], unique=True)

    op.create_table(
        'staff_department_info',
        sa.Column('id', models.base.MagicBigInteger(), nullable=False, autoincrement=False),
        sa.Column('unique_name', sa.String(length=255), nullable=True),
        sa.Column('display_name', sa.String(length=255), nullable=True),
        sa.Column('created_at', models.base.Timestamp(), nullable=False),
        sa.PrimaryKeyConstraint('id'),
    )
    op.create_index('idx_staff_department_info_login', 'staff_department_info', ['unique_name'], unique=False)
    op.create_index('idx_staff_department_info_unique_name', 'staff_department_info', ['unique_name'], unique=True)


def downgrade():
    with op.batch_alter_table('user_roles') as batch_op:
        batch_op.drop_constraint('user_roles_ibfk_1', type_="foreignkey")
        batch_op.drop_constraint('user_roles_ibfk_2', type_="foreignkey")
    op.drop_table('user_roles')
    op.drop_table('user_info')
    op.drop_table('external_records')
    op.drop_table('abc_department_info')
    op.drop_table('staff_department_info')

    with op.batch_alter_table('tags_entities') as batch_op:
        batch_op.drop_constraint('tags_entities_ibfk_1', type_="foreignkey")
    op.drop_table('tags_entities')
    op.drop_table('tags')

    with op.batch_alter_table('bundle_version_to_secret_version') as batch_op:
        batch_op.drop_constraint('bundle_version_to_secret_version_ibfk_1', type_="foreignkey")
        batch_op.drop_constraint('bundle_version_to_secret_version_ibfk_2', type_="foreignkey")
    op.drop_table('bundle_version_to_secret_version')

    with op.batch_alter_table('bundle_versions') as batch_op:
        batch_op.drop_constraint('bundle_versions_ibfk_1', type_="foreignkey")
    op.drop_table('bundle_versions')
    op.drop_table('bundles')

    with op.batch_alter_table('delegation_tokens') as batch_op:
        batch_op.drop_constraint('delegation_tokens_ibfk_1', type_="foreignkey")
    op.drop_table('delegation_tokens')

    with op.batch_alter_table('secret_versions') as batch_op:
        batch_op.drop_constraint('secret_versions_ibfk_1', type_="foreignkey")
    op.drop_table('secret_versions')
    op.drop_table('secrets')
