# coding: utf-8

"""
Add a secret_versions.expired_at column

Revision ID: 1224ba83b29c
Revises: dbe75764b113
Create Date: 2018-08-14 11:52:16.380792

"""

from alembic import op
from passport.backend.vault.api import models
import sqlalchemy as sa


revision = '1224ba83b29c'
down_revision = 'dbe75764b113'
branch_labels = None
depends_on = None


def upgrade():
    op.add_column(
        'secret_versions',
        sa.Column('expired_at', models.base.Timestamp(), nullable=True),
    )
    op.add_column(
        'secret_versions',
        sa.Column('updated_at', models.base.Timestamp(), nullable=True),
    )
    op.add_column(
        'secret_versions',
        sa.Column('updated_by', models.base.MagicBigInteger(), nullable=True),
    )


def downgrade():
    with op.batch_alter_table('secret_versions') as batch_op:
        batch_op.drop_column('expired_at')
        batch_op.drop_column('updated_at')
        batch_op.drop_column('updated_by')
