# coding: utf-8

"""
add db_pool table

Revision ID: 15a78465bcb0
Revises: 1224ba83b29c
Create Date: 2018-09-07 12:15:44.466918

"""

from alembic import op
from passport.backend.vault.api import models
import sqlalchemy as sa


revision = '15a78465bcb0'
down_revision = '1224ba83b29c'
branch_labels = None
depends_on = None


def upgrade():
    op.create_table(
        'db_pool_updates',
        sa.Column('fqdn', sa.String(length=255), nullable=False),
        sa.Column('updated_at', models.base.Timestamp(), nullable=False),
        sa.PrimaryKeyConstraint('fqdn'),
    )

    with op.batch_alter_table('secret_versions') as batch_op:
        batch_op.alter_column('keys', type_=sa.Text())

    with op.batch_alter_table('abc_department_info') as batch_op:
        batch_op.create_unique_constraint('ix_abc_deparment_info_unique_name', ['unique_name'])
        batch_op.drop_index('idx_abc_department_info_login')
        batch_op.drop_index('idx_abc_department_info_unique_name')

    with op.batch_alter_table('staff_department_info') as batch_op:
        batch_op.create_unique_constraint('ix_staff_deparment_info_unique_name', ['unique_name'])
        batch_op.drop_index('idx_staff_department_info_login')
        batch_op.drop_index('idx_staff_department_info_unique_name')

    with op.batch_alter_table('user_info') as batch_op:
        batch_op.create_unique_constraint('ix_user_info_login', ['login'])
        batch_op.drop_index('idx_user_info_login')


def downgrade():
    with op.batch_alter_table('user_info') as batch_op:
        batch_op.create_index('idx_user_info_login', ['login'], unique=False)
        batch_op.drop_constraint('ix_user_info_login', type_='unique')

    with op.batch_alter_table('staff_department_info') as batch_op:
        batch_op.create_index('idx_staff_department_info_unique_name', ['unique_name'], unique=True)
        batch_op.create_index('idx_staff_department_info_login', ['unique_name'], unique=False)
        batch_op.drop_constraint('ix_staff_deparment_info_unique_name', type_='unique')

    with op.batch_alter_table('abc_department_info') as batch_op:
        batch_op.create_index('idx_abc_department_info_unique_name', ['unique_name'], unique=True)
        batch_op.create_index('idx_abc_department_info_login', ['unique_name'], unique=False)
        batch_op.drop_constraint('ix_abc_deparment_info_unique_name', type_='unique')

    with op.batch_alter_table('secret_versions') as batch_op:
        batch_op.alter_column('keys', type_=sa.String(1023))

    op.drop_table('db_pool_updates')
