# coding: utf-8

"""
Add comment and state for tokens

Revision ID: f00c7b3d54bc
Revises: ef2f76db5231
Create Date: 2018-11-12 12:57:53.556868
"""

from alembic import op
from passport.backend.vault.api import models
import sqlalchemy as sa


revision = 'f00c7b3d54bc'
down_revision = 'ef2f76db5231'
branch_labels = None
depends_on = None


def upgrade():
    op.add_column('delegation_tokens', sa.Column('comment', sa.String(length=1023), nullable=True))
    op.add_column('delegation_tokens', sa.Column('state', sa.Integer(), server_default='0', nullable=False))
    op.add_column('delegation_tokens', sa.Column('revoked_at', models.base.Timestamp(), nullable=True))
    op.add_column('delegation_tokens', sa.Column('revoked_by', models.base.MagicBigInteger(), nullable=True))


def downgrade():
    with op.batch_alter_table('delegation_tokens') as batch_op:
        batch_op.drop_column('state')
        batch_op.drop_column('comment')
        batch_op.drop_column('revoked_by')
        batch_op.drop_column('revoked_at')
