# encoding: utf-8
"""

Add tvm_apps_info table

Revision ID: 87b385c49cf8
Revises: ddb37aa51019
Create Date: 2018-12-21 17:31:46.642676

"""
from alembic import op
from passport.backend.vault.api import models
import sqlalchemy as sa


revision = '87b385c49cf8'
down_revision = 'ddb37aa51019'
branch_labels = None
depends_on = None


def upgrade():
    op.create_table('tvm_apps_info',
        sa.Column('tvm_client_id', models.base.MagicBigInteger(), autoincrement=False, nullable=False),
        sa.Column('name', sa.String(length=255), nullable=True),
        sa.Column('url', sa.String(length=1024), nullable=True),
        sa.Column('abc_id', models.base.MagicBigInteger(), nullable=False),
        sa.Column('abc_resource_id', models.base.MagicBigInteger(), nullable=False),
        sa.Column('abc_state', sa.String(length=255), nullable=True),
        sa.Column('abc_state_display_name', sa.String(length=255), nullable=True),
        sa.Column('created_at', models.base.Timestamp(), nullable=False),
        sa.PrimaryKeyConstraint('tvm_client_id'),
        sa.UniqueConstraint('abc_resource_id', name='idx_uq_tvm_apps_info_abc_resource_id')
    )
    op.create_index('idx_tvm_apps_info_abc_id', 'tvm_apps_info', ['abc_id'], unique=False)


def downgrade():
    op.drop_table('tvm_apps_info')
