# coding: utf-8

"""
Add the tvm_grants table

Revision ID: c78cb3d9dc52
Revises: f878ad491f3c
Create Date: 2019-05-30 11:12:03.868072

"""
from alembic import op
from passport.backend.vault.api import models
import sqlalchemy as sa


revision = 'c78cb3d9dc52'
down_revision = 'f878ad491f3c'
branch_labels = None
depends_on = None


def upgrade():
    op.create_table(
        'tvm_grants',
        sa.Column('tvm_client_id', models.base.MagicBigInteger(), autoincrement=False, nullable=False),
        sa.Column('comment', sa.String(length=1023), nullable=True),
        sa.Column('created_at', models.base.Timestamp(), nullable=False),
        sa.PrimaryKeyConstraint('tvm_client_id'),
    )


def downgrade():
    op.drop_table('tvm_grants')
