# coding: utf-8

"""

Add abc roles

Revision ID: 915de301b243
Revises: c78cb3d9dc52
Create Date: 2019-09-03 11:08:19.868180

"""

from alembic import op
from passport.backend.vault.api import models
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = '915de301b243'
down_revision = 'c78cb3d9dc52'
branch_labels = None
depends_on = None


def upgrade():
    is_mysql = (op.get_bind().dialect.name == 'mysql')

    op.create_table('abc_roles',
        sa.Column('id', models.base.MagicInteger(), autoincrement=False, nullable=False),
        sa.Column('display_name', sa.String(length=255), nullable=False),
        sa.Column('english_name', sa.String(length=255), nullable=False),
        sa.Column('created_at', models.base.Timestamp(), nullable=False),
        sa.PrimaryKeyConstraint('id'),
    )
    op.create_table('abc_departments_to_roles',
        sa.Column('abc_department_info', models.base.MagicBigInteger(), nullable=False),
        sa.Column('abc_roles', models.base.MagicInteger(), nullable=False),
        sa.ForeignKeyConstraint(['abc_department_info'], ['abc_department_info.id'], name='abc_departments_to_roles_ibfk_1'),
        sa.ForeignKeyConstraint(['abc_roles'], ['abc_roles.id'], name='abc_departments_to_roles_ibfk_2'),
        sa.PrimaryKeyConstraint('abc_department_info', 'abc_roles')
    )

    # Создаем временный уникальный индекс, чтобы безопасно пересоздать первичный ключ
    op.add_column(
        'external_records',
        sa.Column('external_role_id', models.base.MagicInteger(), nullable=False, server_default='0'),
    )
    op.create_index(
        'tmp_external_records_uniquie_index',
        'external_records',
        ('uid', 'external_type', 'external_id', 'external_scope_id', 'external_role_id'),
        unique=True,
    )
    with op.batch_alter_table('external_records') as batch_op:
        if is_mysql:
            batch_op.drop_constraint(None, type_='primary')
        batch_op.create_primary_key(
            None if is_mysql else 'primary_key',
            ('uid', 'external_type', 'external_id', 'external_scope_id', 'external_role_id'),
        )
    op.drop_index('tmp_external_records_uniquie_index', 'external_records')

    op.create_index(
        'idx_external_records_services_roles',
        'external_records',
        ['external_type', 'external_id', 'external_scope_id', 'external_role_id'],
    )
    op.drop_index('idx_external_records_services', 'external_records')

    op.add_column(
        'user_roles',
        sa.Column('abc_role_id', models.base.MagicInteger(), nullable=True, server_default='0'),
    )
    op.create_index(
        'tmp_user_roles_uq_1',
        'user_roles',
        ['secret_uuid', 'bundle_uuid', 'role_id', 'external_type', 'uid', 'staff_id', 'abc_id', 'abc_scope_id', 'abc_role_id'],
        unique=True,
    )
    with op.batch_alter_table('user_roles') as batch_op:
        # Отрываем старую колонку для искусственного первичного ключа
        # Из базы выпиливаем вручную через две недели после релиза
        batch_op.drop_column('__uniq_key_string__')

        if is_mysql:
            batch_op.drop_constraint(u'user_roles_uq_1', type_='unique')

        batch_op.create_unique_constraint(
            'user_roles_uq_1',
            ['secret_uuid', 'bundle_uuid', 'role_id', 'external_type', 'uid', 'staff_id', 'abc_id', 'abc_scope_id', 'abc_role_id'],
        )
    op.drop_index(
        'tmp_user_roles_uq_1',
        'user_roles',
    )

    op.create_index('idx_user_roles_user_secret', 'user_roles', ['external_type', 'uid', 'secret_uuid'])
    op.create_index('idx_user_roles_abc_secret', 'user_roles', ['external_type', 'abc_id', 'abc_scope_id', 'abc_role_id', 'secret_uuid'])
    op.create_index('idx_user_roles_staff_secret', 'user_roles', ['external_type', 'staff_id', 'secret_uuid'])

    op.drop_index('idx_user_roles_uid', 'user_roles')
    op.drop_index('idx_user_roles_abc_id_scope', 'user_roles')
    op.drop_index('idx_user_roles_staff_id_type', 'user_roles')


def downgrade():
    is_mysql = (op.get_bind().dialect.name == 'mysql')

    op.create_index('idx_user_roles_abc_id_scope', 'user_roles', ['abc_id', 'abc_scope_id', 'external_type']);
    op.create_index('idx_user_roles_uid', 'user_roles', ['uid']),
    op.create_index('idx_user_roles_staff_id_type', 'user_roles', ['staff_id', 'external_type']),

    op.drop_index('idx_user_roles_user_secret', 'user_roles')
    op.drop_index('idx_user_roles_abc_secret', 'user_roles')
    op.drop_index('idx_user_roles_staff_secret', 'user_roles')

    op.create_index(
        'tmp_user_roles_uq_1',
        'user_roles',
        ['secret_uuid', 'bundle_uuid', 'role_id', 'external_type', 'uid', 'staff_id', 'abc_id', 'abc_scope_id'],
        unique=True,
    )
    with op.batch_alter_table('user_roles') as batch_op:
        batch_op.drop_column('abc_role_id')
        batch_op.add_column(
            sa.Column('__uniq_key_string__', sa.CHAR(32), default='', nullable=False),
        )

        if is_mysql:
            batch_op.drop_constraint(u'user_roles_uq_1', type_='unique')

        batch_op.create_unique_constraint(
            'user_roles_uq_1',
            ['secret_uuid', 'bundle_uuid', 'role_id', 'external_type', 'uid', 'staff_id', 'abc_id', 'abc_scope_id'],
        )
    op.drop_index(
        'tmp_user_roles_uq_1',
        'user_roles',
    )

    op.create_index(
        'idx_external_records_services',
        'external_records',
        ['external_type', 'external_id', 'external_scope_id'],
    )
    op.drop_index('idx_external_records_services_roles', 'external_records')

    op.create_index(
        'tmp_external_records_uniquie_index',
        'external_records',
        ('uid', 'external_type', 'external_id', 'external_scope_id'),
        unique=True,
    )
    with op.batch_alter_table('external_records') as batch_op:
        batch_op.drop_column('external_role_id')
        if is_mysql:
            batch_op.drop_constraint(None, type_='primary')
        batch_op.create_primary_key(
            None if is_mysql else 'primary_key',
            ('uid', 'external_type', 'external_id', 'external_scope_id'),
        )
    op.drop_index('tmp_external_records_uniquie_index', 'external_records')

    op.drop_table('abc_departments_to_roles')
    op.drop_table('abc_roles')
