# coding: utf-8

"""
Increase the maximum signature length to 256

Revision ID: 4daeac822a2f
Revises: 915de301b243
Create Date: 2019-11-20 10:48:54.344518
"""

from alembic import op
from passport.backend.vault.api import models
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = '4daeac822a2f'
down_revision = '915de301b243'
branch_labels = None
depends_on = None


def upgrade():
    with op.batch_alter_table('delegation_tokens') as batch_op:
        batch_op.alter_column(
            'signature',
            type_=sa.String(length=255),
            existing_type=sa.String(length=128),
            nullable=True,
        )


def downgrade():
    with op.batch_alter_table('delegation_tokens') as batch_op:
        batch_op.alter_column(
            'signature',
            type_=sa.String(length=128),
            existing_type=sa.String(length=255),
            nullable=True,
        )
