# coding: utf-8

import socket
import time

from passport.backend.vault.api.db import get_db
from passport.backend.vault.api.models.base import (
    BaseModel,
    Timestamp,
)


db = get_db()


def get_fqdn():
    return socket.getfqdn()


class DbPoolUpdates(BaseModel):
    """
    Хак, чтобы не мигал мониторинг реплик, если база простаивает.
    """
    __tablename__ = 'db_pool_updates'
    default_serialization_columns = ['fqdn', 'updated_at']

    fqdn = db.Column(db.String(255), primary_key=True)
    updated_at = db.Column(Timestamp, nullable=False)

    @staticmethod
    def update_pool():
        db.session.merge(
            DbPoolUpdates(
                fqdn=get_fqdn(),
                updated_at=time.time(),
            ),
        )
        db.session.commit()

    @staticmethod
    def get_current_pool():
        return db.session.query(DbPoolUpdates).get(get_fqdn())
