# -*- coding: utf-8 -*-

from flask import Blueprint
from passport.backend.vault.api.views import PingView
from passport.backend.vault.api.views.bundles import (
    CreateBundleVersionView,
    CreateBundleView,
    GetBundleView,
    ListBundlesView,
    UpdateBundleView,
)
from passport.backend.vault.api.views.docs import DocsView
from passport.backend.vault.api.views.golovan import GlobalStatsView
from passport.backend.vault.api.views.grants import TvmGrantsView
from passport.backend.vault.api.views.roles import (
    CreateSecretUserRoleView,
    DeleteSecretUserRoleView,
)
from passport.backend.vault.api.views.secrets import (
    CheckUserCanReadSecretView,
    CreateSecretView,
    CreateSupervisorView,
    GetOwnersView,
    GetReadersView,
    GetSecretView,
    GetWritersView,
    ListSecretsView,
    UpdateSecretView,
)
from passport.backend.vault.api.views.status import StatusView
from passport.backend.vault.api.views.suggest import (
    SuggestView,
    TvmSuggestView,
)
from passport.backend.vault.api.views.switch import SwitchView
from passport.backend.vault.api.views.tags import (
    ListTagsView,
    SuggestTagsView,
)
from passport.backend.vault.api.views.tokens import (
    CreateTokenView,
    GetTokenInfoView,
    ListTokensView,
    RestoreTokenView,
    RevokeTokenView,
    TokenizedRequestsView,
    TokenizedRevokeTokensView,
)
from passport.backend.vault.api.views.versions.views import (
    CreateDiffVersionView,
    CreateSecretVersionView,
    GetVersionView,
    UpdateVersionView,
)
from passport.backend.vault.api.views.web import CreateCompleteSecretView


api_v1 = Blueprint('api_v1', __name__)
golovan = Blueprint('golovan', __name__)


def configure_routes(app):
    api_v1.add_url_rule(
        '/bundles/<string:bundle_uuid>/',
        view_func=GetBundleView.as_view(),
        methods=['GET'],
    )
    api_v1.add_url_rule(
        '/bundles/',
        view_func=ListBundlesView.as_view(),
        methods=['GET'],
    )
    api_v1.add_url_rule(
        '/bundles/',
        view_func=CreateBundleView.as_view(),
        methods=['POST'],
    )
    api_v1.add_url_rule(
        '/bundles/<string:bundle_uuid>/',
        view_func=UpdateBundleView.as_view(),
        methods=['POST'],
    )
    api_v1.add_url_rule(
        '/bundles/<string:bundle_uuid>/versions/',
        view_func=CreateBundleVersionView.as_view(),
        methods=['POST'],
    )

    api_v1.add_url_rule(
        '/versions/<string:version_or_secret_uuid>/',
        view_func=GetVersionView.as_view(),
        methods=['GET'],
    )
    api_v1.add_url_rule(
        '/versions/<string:parent_version_uuid>/',
        view_func=CreateDiffVersionView.as_view(),
        methods=['POST'],
    )
    api_v1.add_url_rule(
        '/versions/<string:version_uuid>/',
        view_func=UpdateVersionView.as_view(),
        methods=['PATCH'],
    )
    api_v1.add_url_rule(
        '/secrets/<string:secret_uuid>/',
        view_func=GetSecretView.as_view(),
        methods=['GET'],
    )
    api_v1.add_url_rule(
        '/secrets/',
        view_func=ListSecretsView.as_view(),
        methods=['GET'],
    )
    api_v1.add_url_rule(
        '/secrets/',
        view_func=CreateSecretView.as_view(),
        methods=['POST'],
    )
    api_v1.add_url_rule(
        '/secrets/<string:secret_uuid>/',
        view_func=UpdateSecretView.as_view(),
        methods=['POST'],
    )
    api_v1.add_url_rule(
        '/secrets/<string:secret_uuid>/versions/',
        view_func=CreateSecretVersionView.as_view(),
        methods=['POST'],
    )
    api_v1.add_url_rule(
        '/secrets/<string:secret_uuid>/tokens/',
        view_func=CreateTokenView.as_view(),
        methods=['POST'],
    )
    api_v1.add_url_rule(
        '/secrets/<string:secret_uuid>/tokens/',
        view_func=ListTokensView.as_view(),
        methods=['GET'],
    )
    api_v1.add_url_rule(
        '/secrets/<string:secret_uuid>/owners/',
        view_func=GetOwnersView.as_view(),
        methods=['GET'],
    )
    api_v1.add_url_rule(
        '/secrets/<string:secret_uuid>/readers/',
        view_func=GetReadersView.as_view(),
        methods=['GET'],
    )
    api_v1.add_url_rule(
        '/secrets/<string:secret_uuid>/writers/',
        view_func=GetWritersView.as_view(),
        methods=['GET'],
    )
    api_v1.add_url_rule(
        '/secrets/<string:secret_uuid>/readers/<string:uid>/',
        view_func=CheckUserCanReadSecretView.as_view(),
        methods=['GET'],
    )
    api_v1.add_url_rule(
        '/tokens/',
        view_func=TokenizedRequestsView.as_view(),
        methods=['POST'],
    )
    api_v1.add_url_rule(
        '/tokens/info/',
        view_func=GetTokenInfoView.as_view(),
        methods=['POST'],
    )
    api_v1.add_url_rule(
        '/tokens/revoke/',
        view_func=TokenizedRevokeTokensView.as_view(),
        methods=['POST'],
    )
    api_v1.add_url_rule(
        '/tokens/<string:token_uuid>/revoke/',
        view_func=RevokeTokenView.as_view(),
        methods=['POST'],
    )
    api_v1.add_url_rule(
        '/tokens/<string:token_uuid>/restore/',
        view_func=RestoreTokenView.as_view(),
        methods=['POST'],
    )
    api_v1.add_url_rule(
        '/secrets/<string:secret_uuid>/roles/',
        view_func=CreateSecretUserRoleView.as_view(),
        methods=['POST'],
    )
    api_v1.add_url_rule(
        '/secrets/<string:secret_uuid>/roles/',
        view_func=DeleteSecretUserRoleView.as_view(),
        methods=['DELETE'],
    )
    api_v1.add_url_rule(
        '/supervisors/',
        view_func=CreateSupervisorView.as_view(),
        methods=['POST'],
    )
    api_v1.add_url_rule(
        '/docs/',
        view_func=DocsView.as_view(),
        methods=['GET'],
    )

    api_v1.add_url_rule(
        '/tags/',
        view_func=ListTagsView.as_view(),
        methods=['GET'],
    )
    api_v1.add_url_rule(
        '/tags/suggest/',
        view_func=SuggestTagsView.as_view(),
        methods=['GET'],
    )

    app.register_blueprint(api_v1, url_prefix='/1')

    golovan.add_url_rule(
        '/global/',
        view_func=GlobalStatsView.as_view(),
        methods=['GET'],
    )

    app.register_blueprint(golovan, url_prefix='/golovan')

    app.add_url_rule(
        '/switch/',
        view_func=SwitchView.as_view(),
        methods=['GET'],
    )
    app.add_url_rule(
        '/suggest/',
        view_func=SuggestView.as_view(),
        methods=['GET'],
    )
    app.add_url_rule(
        '/suggest/tvm/',
        view_func=TvmSuggestView.as_view(),
        methods=['GET'],
    )
    app.add_url_rule(
        '/web/secrets/',
        view_func=CreateCompleteSecretView.as_view(),
        methods=['POST'],
    )
    app.add_url_rule(
        '/ping.html',
        view_func=PingView.as_view(),
        methods=['GET'],
    )
    app.add_url_rule(
        '/status/',
        view_func=StatusView.as_view(),
        methods=['GET'],
    )
    app.add_url_rule(
        '/grants/',
        view_func=TvmGrantsView.as_view(),
        methods=['GET'],
    )
