from passport.backend.vault.api.views import validators
from passport.backend.vault.api.views.base_form import (
    BaseForm,
    FieldList,
    PaginationFormMixin,
    StringField_,
)
from passport.backend.vault.api.views.validators import NAME_REGEXP_VALIDATOR
from wtforms import (
    BooleanField,
    StringField,
)


class GetBundleForm(BaseForm, PaginationFormMixin):
    pass


class CreateBundleForm(BaseForm):
    name = StringField(
        'Name for bundle',
        description='non-unique name for the bundle',
        validators=[
            validators.DataRequired(),
            validators.NAME_REGEXP_VALIDATOR,
            validators.Length(max=255),
        ],
    )
    comment = StringField_(
        'Comment',
        description='comment',
        strip=True,
        validators=[validators.Optional(), validators.Length(max=1023)],
    )


class UpdateBundleForm(BaseForm):
    name = StringField(
        'Name for bundle',
        description='non-unique name for the bundle',
        validators=[
            validators.Optional(),
            NAME_REGEXP_VALIDATOR,
            validators.Length(max=255),
        ],
    )
    comment = StringField_(
        'Comment',
        description='comment',
        strip=True,
        validators=[validators.Optional(), validators.Length(max=1023)],
    )
    state = StringField(
        'state',
        description='state',
        validators=[validators.Optional(), validators.AnyOf(['normal', 'hidden'])],
    )


class CreateBundleVersionForm(BaseForm):
    comment = StringField_(
        'Comment',
        description='comment',
        strip=True,
        validators=[validators.Optional(), validators.Length(max=1023)],
    )
    secret_versions = FieldList(
        StringField('Secret version'),
        description='secret value array',
        min_entries=1,
        max_entries=100,
    )


class ListBundlesForm(BaseForm, PaginationFormMixin):
    starts_with = StringField(
        'Starts with',
        description='filter secrets by name',
        default='',
        validators=[validators.Optional()],
    )
    order_by = StringField(
        'Order by',
        validators=[
            validators.AnyOf([
                'uuid', 'name', 'comment', 'created_at', 'created_by',
                'updated_at', 'updated_by',
            ]),
        ],
        description='column name to sort',
        default='created_at',
    )
    asc = BooleanField(
        'Ascending',
        description='ascending order of sorting, use with order_by',
        default=False,
        false_values=('false', '0', '', 0, False),
    )
    without = StringField(
        'Without',
        description='comma separated list (abc|staff|uid) for excluding abc, staff or uid search from search',
        default='',
    )
