# coding: utf-8

import json

from passport.backend.vault.api.stats.golovan import get_global_metrics
from passport.backend.vault.api.views.base_view import BaseView


class GlobalStatsView(BaseView):
    """
    Глобальная статистика для Голована. Счетчики секретов, версий, токенов и т.п.,
    которые не относятся к конкретному инстансу приложения
    """

    autodoc = False
    required_user_auth = False
    use_slave = True

    def process_request(self):
        return json.dumps(
            [[k + '_axxx', v] for k, v in get_global_metrics().items()]
        )
