# coding: utf-8

from passport.backend.vault.api.models import TvmGrants
from passport.backend.vault.api.views.base_view import BaseView


class TvmGrantsView(BaseView):
    """
    Возвращает список TVM-приложений, которым разрешен доступ в Секретницу с user-ticket
    """
    use_slave = True
    autodoc = False
    required_user_auth = False

    def process_request(self):
        self.response_values.update({
            'tvm_grants': map(
                lambda x: x.serialize(max_depth=4),
                TvmGrants.list(),
            ),
        })
