# -*- coding: utf-8 -*-

import os

from passport.backend.vault.api.db import get_db
from passport.backend.vault.api.errors import (
    PingDatabaseError,
    PingfileError,
)
from passport.backend.vault.api.views.base_view import BaseView
from sqlalchemy.exc import DBAPIError


class PingView(BaseView):
    """
    Ping method (checking aliveness)
    """

    statbox_mode = 'ping'
    autodoc = False
    required_user_auth = False
    use_slave = True

    def check_ping_file(self):
        if not self.config['ping']['enable_pingfile']:
            return

        pingfile = self.config['ping']['pingfile']
        if not os.access(pingfile, os.R_OK):
            raise PingfileError(
                private_info={
                    'pingfile': pingfile,
                }
            )

    def check_db(self):
        try:
            connect = get_db().engine.connect()
            connect.execute('SELECT 1')
        except DBAPIError as e:
            raise PingDatabaseError(
                private_info={
                    'database_error': str(e),
                },
            )

    def process_request(self):
        self.check_ping_file()
        self.check_db()
        return 'Pong\n'
