from passport.backend.vault.api.errors import ExactlyOneFieldError
from passport.backend.vault.api.views import validators
from passport.backend.vault.api.views.base_form import (
    BaseForm,
    IntegerField,
)
from wtforms import StringField


class SecretUserRoleForm(BaseForm):
    uid = IntegerField(
        'UID',
        description='passport user id (uid)',
        validators=[validators.Optional()],
    )
    login = StringField(
        'Login',
        description='yandex login',
        validators=[validators.Optional()],
    )
    abc_id = IntegerField(
        'ABC ID',
        description='ABC ID',
        validators=[validators.Optional()],
    )
    abc_scope = StringField(
        'ABC scope slug',
        description='ABC scope slug',
        validators=[validators.Optional()],
    )
    abc_role_id = IntegerField(
        'ABC role ID',
        description='ABC role ID',
        validators=[validators.Optional()],
    )
    staff_id = IntegerField(
        'Staff ID',
        description='staff ID',
        validators=[validators.Optional()],
    )
    role = StringField(
        'Role',
        description='role',
        validators=[validators.DataRequired(), validators.AnyOf(['OWNER', 'READER', 'APPENDER'])],
    )

    def validate(self):
        if not super(SecretUserRoleForm, self).validate():
            return False

        uniq_subject_fields = [self.abc_id, self.login, self.staff_id, self.uid]
        usf_set_fields = len(filter(lambda x: x.data is not None, uniq_subject_fields))
        if usf_set_fields != 1:
            raise ExactlyOneFieldError(['abc_id', 'login', 'staff_id', 'uid'])

        if not self.abc_id.is_missing:
            if self.abc_role_id.is_missing and self.abc_scope.is_missing:
                self.abc_scope.process_data('development')

            uniq_abc_fields = [self.abc_scope, self.abc_role_id]
            uaf_set_fields = len(filter(lambda x: x.data is not None, uniq_abc_fields))
            if uaf_set_fields != 1:
                raise ExactlyOneFieldError(['abc_scope', 'abc_role_id'])

        return True
