# -*- coding: utf-8 -*-

from passport.backend.vault.api.views import validators
from passport.backend.vault.api.views.base_form import (
    BaseForm,
    CommaSeparatedField,
    IntegerField,
    PaginationFormMixin,
    StringField_,
)
from wtforms import (
    BooleanField,
    StringField,
)


class GetSecretForm(BaseForm, PaginationFormMixin):
    pass


class CreateSecretForm(BaseForm):
    name = StringField(
        'Name for secret',
        description='non-unique name for the secret',
        validators=[
            validators.DataRequired(),
            validators.NAME_REGEXP_VALIDATOR,
            validators.Length(max=255),
        ],
    )
    comment = StringField_(
        'Comment',
        description='comment',
        strip=True,
        validators=[validators.Optional(), validators.Length(max=1023)],
    )
    tags = CommaSeparatedField(
        'Tags',
        description='tag',
        validators=[validators.Optional(), validators.Length(max=1023)],
    )


class UpdateSecretForm(BaseForm):
    name = StringField(
        'Name for secret',
        description='non-unique name for the secret',
        validators=[
            validators.Optional(),
            validators.NAME_REGEXP_VALIDATOR,
            validators.Length(max=255),
        ],
    )
    comment = StringField_(
        'Comment',
        description='comment',
        strip=True,
        validators=[validators.Optional(), validators.Length(max=1023)],
    )
    tags = CommaSeparatedField(
        'Tags',
        description='tag',
        validators=[validators.Optional(), validators.Length(max=1023)],
    )
    state = StringField(
        'state',
        description='state',
        validators=[validators.Optional(), validators.AnyOf(['normal', 'hidden'])],
    )


class CreateSupervisorForm(BaseForm):
    uid = IntegerField(
        'UID',
        description='passport user id (uid)',
        validators=[validators.Optional()],
    )


class ListSecretsForm(BaseForm, PaginationFormMixin):
    role = StringField(
        'Role',
        description='role',
        validators=[validators.Optional(), validators.AnyOf(['READER', 'OWNER', 'APPENDER'])],
    )
    yours = BooleanField(
        'Are you author?',
        description='are you author?',
        default=False,
        false_values=('false', '0', '', 0, False),
    )
    query = StringField(
        'text',
        description='query for searching. Searches in the name or comment of a secret',
        validators=[validators.Optional()],
    )
    query_type = StringField(
        'query_type',
        validators=[
            validators.AnyOf(['infix', 'language', 'exact', 'prefix']),
        ],
        description='Search type: infix - searches for a substring; language - using MySQL full-text search (natural mode); '
                    'exact — searches for an exact match of a string (case-sensitive); '
                    'prefix — searches for a substring at the beginning of a string',
        default='infix',
    )
    order_by = StringField(
        'Order by',
        validators=[
            validators.AnyOf([
                'uuid', 'name', 'comment', 'created_at', 'created_by',
                'updated_at', 'updated_by',
            ]),
        ],
        description='column name to sort',
        default='created_at',
    )
    asc = BooleanField(
        'Ascending',
        description='ascending order of sorting, use with order_by',
        default=False,
        false_values=('false', '0', '', 0, False),
    )
    without = StringField(
        'Without',
        description='comma separated list (abc|staff|uid) for excluding abc, staff or uid search from search',
        default='',
    )
    tags = CommaSeparatedField(
        'Tags',
        description='list of tags',
        validators=[validators.Optional(), validators.Length(max=1023)],
    )
    with_hidden_secrets = BooleanField(
        'With hidden secrets',
        description='add hidden secrets to the list',
        default=False,
        false_values=('false', '0', '', 0, False),
    )
    with_tvm_apps = BooleanField(
        'With TVM applications info',
        description='add TVM apps to the list',
        default=False,
        false_values=('false', '0', '', 0, False),
    )
