# -*- coding: utf-8 -*-

from passport.backend.vault.api.views.base_view import BaseView
from ua_parser import user_agent_parser


class StatusView(BaseView):
    """
    Status method (checking API status)
    """

    autodoc = False
    required_user_auth = False

    def is_deprecated_client(self):
        parsed_user_agent = user_agent_parser.Parse(self.user_agent)
        if parsed_user_agent['user_agent']['family'] == 'YandexVaultClient':
            version = [
                int(parsed_user_agent['user_agent'].get('major', '0')),
                int(parsed_user_agent['user_agent'].get('minor', '0')),
                int(parsed_user_agent['user_agent'].get('patch', '0')),
            ]
            return version < list(map(int, self.config['application']['deprecated_before_version'].split('.')))
        else:
            return None

    def process_request(self):
        self.response_values.update({
            'status': 'ok',
            'is_deprecated_client': self.is_deprecated_client(),
        })
