# coding: utf-8

from passport.backend.vault.api.views import validators
from passport.backend.vault.api.views.base_form import BaseForm
from wtforms import (
    IntegerField,
    StringField,
)


class SuggestForm(BaseForm):
    query = StringField(
        'query',
        validators=[
            validators.DataRequired(),
            validators.Length(min=1, max=255)
        ],
    )

    limit = IntegerField(
        'Results limit',
        description='maximum results to return',
        default=25,
        validators=[validators.Optional(), validators.GreatOrEqualZeroInt()],
    )


class TvmSuggestForm(BaseForm):
    query = StringField(
        'query',
        validators=[
            validators.DataRequired(),
            validators.Length(min=1, max=255)
        ],
    )

    abc_state = StringField(
        'TVM app state',
        description='state',
        validators=[validators.Optional(), validators.AnyOf(['granted', 'deprived'])],
    )

    limit = IntegerField(
        'Results limit',
        description='maximum results to return',
        default=25,
        validators=[validators.Optional(), validators.GreatOrEqualZeroInt()],
    )
