# coding: utf-8

from passport.backend.vault.api.models import (
    AbcDepartmentInfo,
    StaffDepartmentInfo,
    UserInfo,
)
from passport.backend.vault.api.views.base_view import BaseView
from passport.backend.vault.api.views.switch.forms import SwitchForm


class BaseSwitchView(BaseView):
    autodoc = True
    required_user_auth = False


class SwitchView(BaseSwitchView):
    """
    Обменять ID из систем на имена
    -----
    returns = ['uids', 'abc_ids', 'staff_ids']
    raises = []
    example = {
        'data': 'uids=100,101&abc_ids=22&staff_ids=64',
        'response': {
            'uids': [{
                'first_name': u'Vault',
                'last_name': u'Test100',
                'login': u'vault-test-100',
                'uid': 100
            }, {
                'first_name': u'Vault',
                'last_name': u'Test101',
                'login': u'vault-test-101',
                'uid': 101,
            }],
            'abc_ids': [{
                u'display_name': u'\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0430 \u043f\u043e\u0440\u0442\u0430\u043b\u0430',
                u'id': 22,
                u'unique_name': 'custom'
            }],
            'staff_ids': [{
                'display_name': u'\u041e\u0442\u0434\u0435\u043b \u0440\u0430\u043d\u0436\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f',
                'id': 64,
                'unique_name': 'yandex_search_tech_quality'
            }],
            'status': 'ok',
        }
    }
    """
    autodoc = True
    required_user_auth = False
    form = SwitchForm

    def process_uids(self, ids):
        self.response_values.update({
            'uids': UserInfo.get_by_ids(ids),
        })

    def process_abc_ids(self, ids):
        self.response_values.update({
            'abc_ids': AbcDepartmentInfo.get_by_ids(ids)
        })

    def process_staff_ids(self, ids):
        self.response_values.update({
            'staff_ids': StaffDepartmentInfo.get_by_ids(ids)
        })

    def process_request(self, *args, **kwargs):
        if self.processed_form.uids.data:
            self.process_uids(self.processed_form.uids.data.split(','))
        if self.processed_form.abc_ids.data:
            self.process_abc_ids(self.processed_form.abc_ids.data.split(','))
        if self.processed_form.staff_ids.data:
            self.process_staff_ids(self.processed_form.staff_ids.data.split(','))
