# coding: utf-8

from passport.backend.vault.api.models.tags import MAX_TAG_LENGTH
from passport.backend.vault.api.views import validators
from passport.backend.vault.api.views.base_form import (
    BaseForm,
    PaginationFormMixin,
)
from wtforms import StringField


class SuggestTagsForm(BaseForm, PaginationFormMixin):
    text = StringField(
        'Tags text',
        validators=[
            validators.DataRequired(),
            validators.Length(max=MAX_TAG_LENGTH),
        ],
    )
