# -*- coding: utf-8 -*-

from wtforms import validators


class DataRequired(validators.DataRequired):
    """
    Требуются данные для поля
    Пример: {'errors': {'name': ['required']}}
    """
    def __init__(self):
        super(DataRequired, self).__init__(message='required')


class DataNotNone(validators.DataRequired):
    """
    Требуются данные для поля
    Пример: {'errors': {'name': ['required']}}
    """
    def __init__(self):
        super(DataNotNone, self).__init__(message='required')

    def __call__(self, form, field):
        if field.is_missing:
            field.errors[:] = []
            raise validators.StopValidation(self.message)
        elif not field.data:
            field.data = ''


class Length(validators.Length):
    """
    Длина поля должна вписываться в ограничения
    Пример: {'errors': {'name': ['length: 1_to_255']}}
    """
    def __init__(self, min=1, max=255):
        super(Length, self).__init__(
            min=min,
            max=max,
            message='length: %d_to_%d' % (min, max),
        )


class Regexp(validators.Regexp):
    """
    Поле должно соответствовать регулярному выражению
    Пример: {'errors': {'name': ['regexp: [a-z]+']}}
    """
    def __init__(self, regex, *args, **kwargs):
        super(Regexp, self).__init__(regex=regex, message='regexp: %s' % regex, *args, **kwargs)


class AnyOf(validators.AnyOf):
    """
    Поле должно иметь одно их следующий значений
    Пример: {'errors': {'name': ['any_of: ["A","B"]']}}
    """
    def __init__(self, values):
        super(AnyOf, self).__init__(values=values, message='any_of: %s' % values)


class Optional(validators.Optional):
    pass


class OptionalNotNone(validators.DataRequired):
    """
    Требуются данные для поля
    Пример: {'errors': {'name': ['required']}}
    """
    def __init__(self):
        super(OptionalNotNone, self).__init__(message='required')

    def __call__(self, form, field):
        if not field.is_missing and not field.data:
            field.data = ''


NAME_REGEXP_VALIDATOR = Regexp(r'^[a-zA-Z0-9_\-\.]+$')


class GreatOrEqualZeroInt(object):
    def __call__(self, form, field):
        try:
            value = int(field.data)
        except ValueError:
            raise validators.ValidationError('The field must be of type integer')

        if value < 0:
            raise validators.ValidationError('The field must be equal or great then zero')
