from passport.backend.vault.api.views import validators
from passport.backend.vault.api.views.base_form import (
    BaseForm,
    FieldList,
    StringField_,
)
from wtforms import (
    BooleanField,
    FormField,
    IntegerField,
    StringField,
)


class SecretVersionValueForm(BaseForm):
    key = StringField(
        'Key',
        description='key',
        validators=[validators.DataRequired(), validators.NAME_REGEXP_VALIDATOR, validators.Length(max=255)],
    )
    value = StringField(
        'Value',
        description='secret value',
        validators=[validators.DataNotNone()],
    )
    encoding = StringField(
        'Encoding',
        description='value encoding',
        validators=[validators.Optional(), validators.AnyOf(['base64'])],
    )


class DiffSecretValuesForm(BaseForm):
    key = StringField(
        'Key',
        description='key',
        validators=[validators.DataRequired(), validators.NAME_REGEXP_VALIDATOR, validators.Length(max=255)],
    )
    value = StringField(
        'Value',
        description='secret value',
        validators=[validators.OptionalNotNone()],
    )
    encoding = StringField(
        'Encoding',
        description='value encoding',
        validators=[validators.Optional(), validators.AnyOf(['base64'])],
    )


class CreateDiffSecretVersionForm(BaseForm):
    diff = FieldList(
        FormField(DiffSecretValuesForm),
        description='secret value diff array',
        min_entries=0,
    )
    ttl = IntegerField(
        'ttl',
        description='version ttl',
        validators=[validators.Optional(), validators.GreatOrEqualZeroInt()],
    )
    comment = StringField_(
        'Comment',
        description='comment',
        strip=True,
        validators=[validators.Optional(), validators.Length(max=1023)],
    )
    check_head = BooleanField(
        'check_head',
        description='throw error if parent version is not equal to head version',
        default=False,
        false_values=('false', '0', '', 0, False),
    )


class CreateSecretVersionForm(BaseForm):
    value = FieldList(
        FormField(SecretVersionValueForm),
        description='secret value array',
        min_entries=1,
    )
    ttl = IntegerField(
        'ttl',
        description='version ttl',
        validators=[validators.Optional(), validators.GreatOrEqualZeroInt()],
    )
    comment = StringField_(
        'Comment',
        description='comment',
        strip=True,
        validators=[validators.Optional(), validators.Length(max=1023)],
    )


class UpdateSecretVersionForm(BaseForm):
    state = StringField(
        'state',
        description='state',
        validators=[validators.Optional(), validators.AnyOf(['normal', 'hidden'])],
    )
    ttl = IntegerField(
        'ttl',
        description='version ttl',
        validators=[validators.Optional(), validators.GreatOrEqualZeroInt()],
    )
    comment = StringField_(
        'Comment',
        description='comment',
        strip=True,
        validators=[validators.Optional(), validators.Length(max=1023)],
    )


class SecretVersionForm(BaseForm):
    secret_version = StringField(
        'Secret version',
        description='secret version',
        validators=[validators.DataRequired()],
    )
