# -*- coding: utf-8 -*-

from passport.backend.vault.api.models import UserRole
from passport.backend.vault.api.views.roles.views import CreateSecretUserRoleView
from passport.backend.vault.api.views.secrets import CreateSecretView
from passport.backend.vault.api.views.versions import CreateSecretVersionView
from passport.backend.vault.api.views.web.forms import CreateCompleteSecretForm


class CreateCompleteSecretView(CreateSecretView, CreateSecretVersionView, CreateSecretUserRoleView):
    """
    Создать новый секрет
    -----
    returns = ['uuid']
    raises = [UserAuthRequiredError, AccessError, ValidationError]
    example = {
        'headers': {'Content-Type': 'application/json'},
        'data': {
            'name': 'passport_top_secret_1',
            'comment': 'Dont touch',
            'tags': 'yp,search',
            'secret_version': {
                'comment': 'ololo',
                'value': [{'key': 'password', 'value': '123456'}],
            },
            'roles': [{
                'uid': 101, 'role': 'OWNER',
            }, {
                'abc_id': 14, 'role': 'READER',
            }, {
                'staff_id': 4112, 'role': 'READER',
            }],
        },
        'response': {
            'uuid': 'sec-0000000000000000000000ygj0',
            'secret_version': 'ver-0000000000000000000000ygj3',
            'status': 'ok',
        },
    }
    """
    form = CreateCompleteSecretForm
    statbox_mode = 'create_complete_secret'

    def process_request(self):
        secret = self.create_secret(form=self.processed_form)
        if not self.processed_form.secret_version.is_missing:
            self.create_secret_version(secret=secret, form=self.processed_form.secret_version)
        if not self.processed_form.roles.is_missing:
            for role_form in self.processed_form.roles.entries:
                UserRole.safely_add_user_role_to_secret(
                    self.make_user_role(secret=secret, form=role_form),
                )
        self.commit()
