PY2_LIBRARY(vault_api)

OWNER(
    g:passport_python
)

NEED_REVIEW()

PEERDIR(
    passport/backend/core/builders/abc
    passport/backend/core/builders/blackbox
    passport/backend/core/builders/staff
    passport/backend/core/builders/xunistater
    passport/backend/core/builders/yasm_agent
    passport/backend/core/crypto
    passport/backend/core/lazy_loader
    passport/backend/core/logging_utils
    passport/backend/core/tvm

    passport/backend/library/configurator
    passport/backend/library/log
    passport/backend/library/wsgi_runner
    passport/backend/utils
    passport/backend/vault/utils

    contrib/python/alembic
    contrib/python/click
    contrib/python/Flask
    contrib/python/Flask-WTF
    contrib/python/flask_migrate
    contrib/python/Flask-SQLAlchemy
    contrib/python/gevent
    contrib/python/gunicorn
    contrib/python/lz4
    contrib/python/paramiko
    contrib/python/PyMySQL
    contrib/python/requests
    contrib/python/simplejson
    contrib/python/sqlalchemy/sqlalchemy-1.2
    contrib/python/tabulate
    contrib/python/WTForms
    contrib/python/WTForms-JSON
    contrib/python/ua-parser
    library/python/yenv

    library/python/cityhash
    library/python/deprecated/ticket_parser2
    library/python/vault_client
)

PY_SRCS(
    __init__.py
    app.py

    builders/__init__.py
    builders/abc.py
    builders/blackbox.py
    builders/loggers.py
    builders/staff.py

    commands/__init__.py
    commands/base.py
    commands/download.py
    commands/find.py
    commands/generate.py
    commands/golovan.py
    commands/grants.py
    commands/roles.py
    commands/service.py

    db/__init__.py

    default_secret_settings.py
    dynamic_settings.py

    errors/__init__.py

    models/__init__.py
    models/abc_department_info.py
    models/base.py
    models/bundle.py
    models/bundle_version.py
    models/db_pool_updates.py
    models/delegation_token.py
    models/external_record.py
    models/secret.py
    models/secret_version.py
    models/staff_department_info.py
    models/tags.py
    models/tvm_app_info.py
    models/tvm_grants.py
    models/user_info.py
    models/user_role.py

    routes/__init__.py

    stats/__init__.py
    stats/golovan.py

    tvm/__init__.py

    utils/__init__.py
    utils/errors.py
    utils/json.py
    utils/secrets.py
    utils/ulid.py

    value_manager/__init__.py

    views/__init__.py
    views/base_form.py
    views/base_view.py
    views/ping_view.py
    views/validators.py

    views/bundles/__init__.py
    views/bundles/forms.py
    views/bundles/views.py

    views/docs/__init__.py
    views/docs/views.py

    views/golovan/__init__.py
    views/golovan/views.py

    views/grants/__init__.py
    views/grants/views.py

    views/roles/__init__.py
    views/roles/forms.py
    views/roles/views.py

    views/secrets/__init__.py
    views/secrets/forms.py
    views/secrets/views.py

    views/status/__init__.py
    views/status/views.py

    views/suggest/__init__.py
    views/suggest/forms.py
    views/suggest/views.py

    views/switch/__init__.py
    views/switch/forms.py
    views/switch/views.py

    views/tags/__init__.py
    views/tags/forms.py
    views/tags/views.py

    views/tokens/__init__.py
    views/tokens/forms.py
    views/tokens/views.py

    views/versions/__init__.py
    views/versions/forms.py
    views/versions/views.py

    views/web/__init__.py
    views/web/forms.py
    views/web/views.py
)

RESOURCE(
    configs/base.yaml /etc/yandex/passport-vault/base.yaml
    configs/development.yaml /etc/yandex/passport-vault/development.yaml
    configs/export.yaml /etc/yandex/passport-vault/export.yaml
    configs/flask.yaml /etc/yandex/passport-vault/flask.yaml
    configs/logging.yaml /etc/yandex/passport-vault/logging.yaml
    configs/production.yaml /etc/yandex/passport-vault/production.yaml
    configs/stress.yaml /etc/yandex/passport-vault/stress.yaml
    configs/testing.yaml /etc/yandex/passport-vault/testing.yaml
    keys/development.keys /usr/lib/yandex/passport-vault-secrets/development.keys
)

END()

RECURSE(
    bin
    deb/logbroker_client
)

RECURSE_FOR_TESTS(
    tests
    tests_highload
    deb/xunistater/etc/yandex/passport-xunistater
)

