# -*- coding: utf-8 -*-

import re

from setuptools import setup


with open('vault_client/__init__.py') as f:
    version_re = re.compile(r'__version__\s*=\s*\'(\d+\.\d+\.\d+)\'')
    version = version_re.search(f.read()).group(1)

client_requires = [
    'cryptography>=2.2.1',
    'paramiko>=2.4.0',
    'pyopenssl>=18.0.0',
    'requests>=2.18.4',
    'six>=1.11.0',
]

cli_requires = [
    'argcomplete>=1.9.4',
    'configparser>=3.5.0',
    'Jinja2>=2.10',
    'jmespath>=0.9.4',
    'PyYAML>=3.13',
    'tabulate>=0.7.5',
    'yenv>=0.8',
]

setup(
    name='yandex-passport-vault-client',
    version=version,
    author='Passport Developers',
    author_email='passport-dev@yandex-team.ru',
    url='https://vault-api-test.passport.yandex.net/docs/',
    packages=[
        'vault_client',
        'vault_client_cli',
        'vault_client_cli.commands',
        'vault_client_deploy',
        'passport',
        'passport.python',
        'passport.backend.utils',
        'passport.backend.vault.utils',
    ],
    install_requires=list([client_requires, cli_requires]),
    dependency_links=[
        'https://pypi.yandex-team.ru/simple/',
        'https://pypi.yandex-team.ru/simple/yenv/',
    ],
    include_package_data=True,
    package_data={
        'vault_client': [
            'vault_client/YandexInternalRootCA.crt',
        ],
    },
    entry_points={
        'console_scripts': [
            'yav = vault_client_cli:run_cli',
            'yav-deploy = vault_client_deploy:run_app',
        ],
    },
)
