import json


class BaseBullet(object):
    default_headers = {
        'User-Agent': 'Passport-Load-Agent',
        'Connection': 'Keep-Alive',
        'Host': 'vault-load.passport.yandex.net',
    }

    def __init__(self, method, path, headers=None, data=None, name=None):
        self.name = name
        self.method = method
        self.path = path
        self.headers = headers
        self.data = data

    def __str__(self):
        headers = dict(self.default_headers)
        if self.headers:
            headers.update(self.headers)
        if self.data is not None:
            headers['Content-Length'] = len(self.data)
        headers = '\r\n'.join('%s: %s' % (key, value) for key, value in headers.items())
        r = '{method} {path} HTTP/1.1\r\n{headers}\r\n\r\n{data}'.format(
            method=self.method, path=self.path, headers=headers, data=self.data + '\r\n' if self.data is not None else ''
        )
        return '%d\n%s' % (len(r), r)


class PingBullet(BaseBullet):
    def __init__(self):
        super(PingBullet, self).__init__(
            method='GET',
            path='/ping.html',
        )


class GetVersionBullet(BaseBullet):
    def __init__(self, version):
        super(GetVersionBullet, self).__init__(
            method='GET',
            path='/1/versions/%s/' % version,
            headers={
                'Authorization': 'OAuth xxx',
            }
        )


class DelegationTokenBullet(BaseBullet):
    def __init__(self, token):
        super(DelegationTokenBullet, self).__init__(
            method='POST',
            path='/1/tokens/',
            headers={
                'Content-Type': 'application/json',
            },
            data=json.dumps({'tokenized_requests': [{'token': token}]}),

        )

bullets = [
    DelegationTokenBullet('xxx')
    # GetVersionBullet('ver-01ct49meaeqqtath3rerzd617j'),  # Little secret
    # GetVersionBullet('ver-01ct49kj52eg50eyj7pf8n3j5n'),  # Large secret
]

with open('ammo.txt', 'w') as f:
    for bullet in bullets:
        f.write(str(bullet))
