package yapic2

import (
	"net/http"

	"github.com/labstack/echo/v4"

	"a.yandex-team.ru/library/go/yandex/tvm"
	"a.yandex-team.ru/passport/shared/golibs/httpdaemon"
	"a.yandex-team.ru/passport/shared/golibs/httpdaemon/httpdtvm"
	"a.yandex-team.ru/passport/shared/golibs/logger"
	"a.yandex-team.ru/passport/shared/golibs/unistat"
)

type Yapic2 struct {
	tvm     tvm.Client
	unistat stats
}

type Config struct {
	Tvm httpdtvm.TvmConfig `json:"tvm"`
}

type stats struct {
	requestsByPath *unistat.SignalSet
}

type Factory struct{}

func (f *Factory) NewService(config httpdaemon.ServiceConfig) (httpdaemon.Service, error) {
	var cfg Config
	if err := httpdaemon.ParseServiceConfig(config, &cfg); err != nil {
		return nil, err
	}

	tvmClient, err := httpdtvm.InitTvm(cfg.Tvm)
	if err != nil {
		return nil, err
	}

	res := &Yapic2{
		tvm: tvmClient,
		unistat: stats{
			requestsByPath: unistat.DefaultChunk.CreateSignalSet("in.requests."),
		},
	}
	return res, nil
}

func (t *Yapic2) AddHandlers(e *echo.Echo) {
	t.unistat.requestsByPath.CreateSignal("/ping")

	e.GET(
		"/ping",
		t.HandlePing(),
	)
}

func (t *Yapic2) HandlePing() echo.HandlerFunc {
	return func(c echo.Context) error {
		logger.Log().Debugf("Ping: service is up")
		return c.String(http.StatusOK, "")
	}
}
