# Куки системы авторизации

Авторизуя пользователя, Паспорт выставляет авторизационную куку `Session_id`. Авторизационная кука считается валидной, если она успешно проходит проверку системы авторизации: срок жизни куки не истек, и содержащаяся в ней подпись подлинная.

Валидная авторизационная кука идентифицирует учетную запись и дает пользователю возможность управлять личными данными в Паспорте. Проверить куку можно с помощью метода Черного ящика [sessionid](https://doc.yandex-team.ru/blackbox/reference/MethodSessionID.xml).

В зависимости от результата проверки, сервис должен [продлевать авторизационные куки](authorization-policy-resign.md). Также может понадобиться синхронизировать выставляемые куки между доменами Яндекса. Для синхронизации кук предназначен механизм [мультидоменной авторизации](MDA_About.md).

## Прочие паспортные куки

Помимо авторизационных кук, Паспорт выставляет в браузер пользователя также следующие куки:
- `L` — содержит подписанную строку с UID, логином и временем последней авторизации. Не удаляется при завершении сессии.
- `yandex_login` — содержит логин учетной записи, с помощью которой пользователь авторизован в данный момент. Удаляется при завершении сессии. Может содержать незакодированные символы UTF-8 (вопреки [RFC 6265](http://tools.ietf.org/html/rfc6265#section-4.1.1)).
- `yp` и `ys` — при авторизации Паспорт записывает в [Y-контейнеры](http://wiki.yandex-team.ru/Cookies/Y) поле `udn`, в котором хранится [отображаемое имя пользователя](DB_About.md#display-name). Поле удаляется из куки при завершении сессии.
- `yandexuid` — идентификатор браузера в статистике. Выставляется, если такая кука отсутствует. Не удаляется при завершении сессии.


