# Часто используемые данные системы авторизации

Система авторизации хранит данные об учетных записях и подписках пользователей на сервисы.

Сервисы могут запрашивать имеющиеся данные с помощью API Черного ящика (описан в документе [Программный интерфейс сервиса Яндекс.blackbox](https://doc.yandex-team.ru/blackbox/concepts/about.xml)). Для изменения и дополнения данных предназначен API Паспорта (описан в документе [Режимы Паспорта](https://doc.yandex-team.ru/Passport/passport-modes/concepts/about.html)).

Поля с данными системы авторизации приведены в таблице [Типы атрибутов](#db-attributes). Номера атрибутов указываются в параметре [attributes](https://docs.yandex-team.ru/blackbox/methods/userinfo#request_format) при запросах к API Черного ящика.

В API ЧЯ также существует устаревший способ получения данных при помощи параметра [dbfields](https://docs.yandex-team.ru/blackbox/methods/userinfo#request_format). Сервисы, которым необходимо получать пользовательские данные таким способом, могут использовать таблицы [accounts](#accounts), [userinfo](#userinfo) и [subscription](#subscription-table).

В таблице [Типы алиасов](#aliases) приведены все существующие [алиасы пользователей](Account_About.md#section_lry_jnq_pcb).

## Типы алиасов {#aliases}

Тип | Имя | Примечание | Связанный SID
----- | ----- | ----- | -----
1 | `portal` | Алиас портального аккаунта. Может использоваться в любом контексте, где требуется логин пользователя. |
2 | `mail` | Почтовый алиас. Используется пользователями, у которых адрес почтового ящика не совпадает с портальным алиасом. Используется при доставке почты или поиске по e-mail. Аккаунты с данным алиасом также обязательно имеют [портальный алиас](#portal-alias). | 2
3 | `narodmail` | Алиас почты на Народе, если он не совпадает с портальным алиасом. Аккаунты с данным алиасом также обязательно имеют [портальный алиас](#portal-alias). | 16
5 | `lite` | Лайт-пользователь. В алиасе хранится подтвержденный e-mail стороннего сервиса. | 33
6 | `social` | Социальный аккаунт. В алиасе хранится сгенерированный идентификатор, недоступный пользователю. Аккаунт может быть дорегистрирован и иметь портальный алиас. | 58
7 | `pdd` | Пользователь Почты Для Домена. Хранит информацию о пользователе в формате `пользователь@домен`. Доменная часть идентификатора может меняться при редактировании имени домена. | 2
8 | `pddalias` | Алиасы ПДД-пользователя. Пользователь ПДД может иметь несколько алиасов. | 105
9 | `altdomain` | Аккаунты в альтернативных доменах, принадлежащих Яндексу. Аналогичен алиасу ПДД. | 61
10 | `phonish` | Алиас телефонного аккаунта. Не рекомендуется использовать из-за сложностей с переходом телефонного номера от одного владельца другому. | 68
11 | `phonenumber` | Телефонный алиас. Обеспечивает поиск по телефонному номеру, уникальному для портального аккаунта. | 65
12 | `mailish` | Технический алиас для сбора почты со сторонних почтовых сервисов. |
13 | `yandexoid` | Логин сотрудника Яндекса, подтвердившего свой аккаунт на Стаффе. Наличие алиаса является признаком сотрудника. | 669
15 | `kinopoisk` | Технический алиас, содержащий идентификатор аккаунта Кинопоиска. |
16 | `uberid` | Технический алиас, содержащий идентификатор аккаунта Uber. |
17 | `yambot` | Технический алиас для идентификации ботов или каналов нового мессенджера. |
18 | `kolonkish` | Технический алиас для идентификации пользователей Яндекс.Станции. |
19 | `publicid` | Выставленный вручную [public_id](https://docs.yandex-team.ru/blackbox/concepts/ugc#public-id-use). |
20 | `oldpublicid` | Предыдущие значения алиаса [public_id](https://docs.yandex-team.ru/blackbox/concepts/ugc#public-id-use). |
21 | `neophonish` | Синтетический алиас для неофонишей. |
22 | `kiddish` | Синтетический алиас для детских профилей. |
23 | `scholar` | Алиас для учеников из Яндекс.Учебника. |
24 | `federal` | Алиас для федераций с внешними системами - он же SAML. |
25 | `bank_phone_number` | Банковский номер телефона. |


##  Типы атрибутов {#db-attributes}

#### 1
account.registration_datetime

Дата и время регистрации пользователя, unixtime.

#### 6
account.is_pdd_agreement_accepted
[sid](https://wiki.yandex-team.ru/passport/SIDs/): 102

Признак того, что пользователь принял соглашение ПДД. Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`. Если признак отсутствует, поля в ответе не будет.

#### 7
account.is_pdd_admin
[sid](https://wiki.yandex-team.ru/passport/SIDs/): 104

Признак того, что пользователь является администратором ПДД домена. Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`. Если признак отсутствует, поля в ответе не будет.

#### 8
account.is_betatester
[sid](https://wiki.yandex-team.ru/passport/SIDs/): 668

Признак того, что пользователь является бета-тестером.Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`. Если признак отсутствует, поля в ответе не будет.

#### 9
account.is_corporate
[sid](https://wiki.yandex-team.ru/passport/SIDs/): 670

Признак того, что данный аккаунт создан яндексоидом и используется для корпоративных нужд.  Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`. Если признак отсутствует, поля в ответе не будет.

#### 10
account.is_vip
[sid](https://wiki.yandex-team.ru/passport/SIDs/): 671

Признак VIP-аккаунта. В данный момент не используется. Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`. Если признак отсутствует, поля в ответе не будет.

#### 12
account.is_employee
[sid](https://wiki.yandex-team.ru/passport/SIDs/): 1000

Признак того, что пользователь является сотрудником Яндекса или роботным аккаунтом. Атрибут используется только во [внутреннем ЧЯ](https://docs.yandex-team.ru/blackbox/concepts/location#section_internal). Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`. Если признак отсутствует, поля в ответе не будет.

#### 13
account.is_maillist
[sid](https://wiki.yandex-team.ru/passport/SIDs/): 1000

Признак того, что аккаунт является почтовой рассылкой. Атрибут используется только во [внутреннем ЧЯ](https://docs.yandex-team.ru/blackbox/concepts/location#section_internal). Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`. Если признак отсутствует, поля в ответе не будет.

#### 15
person.contact_phone_number
[sid](https://wiki.yandex-team.ru/passport/SIDs/): 89

Контактный номер телефона.

❗️ Требует гранта.

#### 20
password.update_datetime

Дата и время обновления пароля. Поле присутствует у всех пользователей, для которых не включена двухфакторная аутентификация.

#### 21
password.quality

Качество пароля пользователя.

❗️ Требует гранта.

#### 22
password.forced_changing_reason
[sid](https://wiki.yandex-team.ru/passport/SIDs/): 8

Причина, по которой пользователю требуется изменить пароль. Возможные значения:<br/><br/>- 1 — подозрение на взлом аккаунта.<br/>- 2 — пароль был сброшен пользователем.

#### 23
password.is_creating_required
[sid](https://wiki.yandex-team.ru/passport/SIDs/): 100

Признак того, что пользователю потребуется создать пароль. Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`. Если признак отсутствует, поля в ответе не будет.

#### 24
account.is_strong_password_required
[sid](https://wiki.yandex-team.ru/passport/SIDs/): 67

Признак того, что пароль пользователя защищен дополнительными требованиями на сложность. Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`. Если признак отсутствует, поля в ответе не будет.

#### 27
person.firstname

Имя пользователя.<br/>

❗️ Требует гранта.

#### 28
person.lastname

Фамилия пользователя.<br/>

❗️ Требует гранта.

#### 29
person.gender

Пол пользователя. Возможные значения:<br/>- `m` — мужчина.<br/>- `f` — женщина.<br/>- атрибут отсутствует — пол не указан.<br/>

❗️ Требует гранта.

#### 30
person.birthday

День рождения пользователя, дата.<br/>

❗️ Требует гранта.

#### 31
person.country

Страна проживания пользователя.

#### 32
person.city

Город проживания пользователя.

#### 33
person.timezone

Часовой пояс пользователя.

#### 34
person.language

Язык интерфейса для пользователя.

#### 35
phone.number

Телефонный номер пользователя. Устаревший атрибут, для получения информации о телефоне пользователя используйте таблицу [телефонных атрибутов](#section_kbk_b5f_2hb).

❗️ Требует гранта.

#### 36
phone.confirmation_datetime

Дата и время подтверждения телефонного номера пользователя.<br/><br/>Устаревший атрибут, для получения информации о телефоне пользователя используйте таблицу [телефонных атрибутов](#section_kbk_b5f_2hb).

#### 44
subscription.fotki
[sid](https://wiki.yandex-team.ru/passport/SIDs/): 5

Признак [подписки](SID_About.md) пользователя на Яндекс.Фотки (сервис закрыт).<br/><br/> Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`. Если признак отсутствует, поля в ответе не будет.

#### 45
subscription.cards
[sid](https://wiki.yandex-team.ru/passport/SIDs/): 6

Признак [подписки](SID_About.md) пользователя на Яндекс.Открытки (сервис закрыт).<br/><br/> Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`. Если признак отсутствует, поля в ответе не будет.

#### 46
subscription.news
[sid](https://wiki.yandex-team.ru/passport/SIDs/): 9

Признак [подписки](SID_About.md) пользователя на Яндекс.Новости.<br/><br/> Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`. Если признак отсутствует, поля в ответе не будет.

#### 48
subscription.direct
[sid](https://wiki.yandex-team.ru/passport/SIDs/): 14

Признак [подписки](SID_About.md) пользователя на Директ.<br/><br/> Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`. Если признак отсутствует, поля в ответе не будет.

#### 49
subscription.spamooborona
[sid](https://wiki.yandex-team.ru/passport/SIDs/): 17

Признак [подписки](SID_About.md) пользователя на Спамоборону.<br/><br/> Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`. Если признак отсутствует, поля в ответе не будет.

#### 50
subscription.balance
[sid](https://wiki.yandex-team.ru/passport/SIDs/): 19

Признак [подписки](SID_About.md) пользователя на Баланс-Биллинг.<br/><br/> Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`. Если признак отсутствует, поля в ответе не будет.

#### 52
subscription.23
[sid](https://wiki.yandex-team.ru/passport/SIDs/): 23

Признак [подписки](SID_About.md) пользователя на [Ленту](https://ru.wikipedia.org/wiki/Яндекс.Лента). <br/> Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`. Если признак отсутствует, поля в ответе не будет.

#### 53
subscription.24
[sid](https://wiki.yandex-team.ru/passport/SIDs/): 24

Признак [подписки](SID_About.md) пользователя на РСЯ. <br/> Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`. Если признак отсутствует, поля в ответе не будет.

#### 54
subscription.25
[sid](https://wiki.yandex-team.ru/passport/SIDs/): 25

Признак [подписки](SID_About.md) пользователя на Маркет. <br/> Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`. Если признак отсутствует, поля в ответе не будет.

#### 55
subscription.26
[sid](https://wiki.yandex-team.ru/passport/SIDs/): 26

Признак [подписки](SID_About.md) пользователя на блог-платформу ya.ru (сервис закрыт). <br/> Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`. Если признак отсутствует, поля в ответе не будет.

#### 56
subscription.jabber.login_rule
[sid](https://wiki.yandex-team.ru/passport/SIDs/): 27

Признак [подписки](SID_About.md) пользователя на Я.онлайн (сервис закрыт).<br/><br/> Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`. Если признак отсутствует, поля в ответе не будет.

#### 57
subscription.29
[sid](https://wiki.yandex-team.ru/passport/SIDs/): 29

Признак [подписки](SID_About.md) пользователя на [Телепрограмму](https://tv.yandex.ru). <br/> Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`. Если признак отсутствует, поля в ответе не будет.

#### 58
subscription.30
[sid](https://wiki.yandex-team.ru/passport/SIDs/): 30

Признак [подписки](SID_About.md) пользователя на Яндекс.Афишу. <br/> Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`. Если признак отсутствует, поля в ответе не будет.

#### 59
subscription.31
[sid](https://wiki.yandex-team.ru/passport/SIDs/): 31

Признак [подписки](SID_About.md) пользователя на Яндекс.Календарь. <br/> Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`. Если признак отсутствует, поля в ответе не будет.

#### 62
subscription.39
[sid](https://wiki.yandex-team.ru/passport/SIDs/): 39

Признак [подписки](SID_About.md) пользователя на Видеохостинг. <br/> Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`. Если признак отсутствует, поля в ответе не будет.

#### 63
subscription.40
[sid](https://wiki.yandex-team.ru/passport/SIDs/): 40

Признак [подписки](SID_About.md) пользователя на kraski.yandex.ru (сервис закрыт). <br/> Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`. Если признак отсутствует, поля в ответе не будет.

#### 64
subscription.41
[sid](https://wiki.yandex-team.ru/passport/SIDs/): 41

Признак [подписки](SID_About.md) пользователя на Яндекс.Словари (сервис закрыт). <br/> Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`. Если признак отсутствует, поля в ответе не будет.

#### 65
subscription.wwwdgt.mode
[sid](https://wiki.yandex-team.ru/passport/SIDs/): 42

Настройки виджетной морды пользователя.

#### 66
subscription.disk.login_rule
[sid](https://wiki.yandex-team.ru/passport/SIDs/): 44

Признак [подписки](SID_About.md) пользователя на Народный диск.<br/><br/> Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`. Если признак отсутствует, поля в ответе не будет.

#### 68
subscription.47
[sid](https://wiki.yandex-team.ru/passport/SIDs/): 47

Признак [подписки](SID_About.md) пользователя на Яндекс.Вебмастер. <br/> Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`. Если признак отсутствует, поля в ответе не будет.

#### 69
subscription.48
[sid](https://wiki.yandex-team.ru/passport/SIDs/): 48

Признак [подписки](SID_About.md) пользователя на Яндекс.Метрику. <br/> Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`. Если признак отсутствует, поля в ответе не будет.

#### 70
subscription.49
[sid](https://wiki.yandex-team.ru/passport/SIDs/): 49

Признак [подписки](SID_About.md) пользователя на Яндекс.Карты. <br/> Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`. Если признак отсутствует, поля в ответе не будет.

#### 71
subscription.50
[sid](https://wiki.yandex-team.ru/passport/SIDs/): 50

Признак [подписки](SID_About.md) пользователя на Яндекс.Музыку для партнеров. <br/> Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`. Если признак отсутствует, поля в ответе не будет.

#### 72
subscription.51
[sid](https://wiki.yandex-team.ru/passport/SIDs/): 51

Признак [подписки](SID_About.md) пользователя на [Яндекс.Радиосводки](http://radioprobki.yandex.ru). <br/> Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`. Если признак отсутствует, поля в ответе не будет.

#### 73
subscription.52
[sid](https://wiki.yandex-team.ru/passport/SIDs/): 52

Признак [подписки](SID_About.md) пользователя на [Народную Карту](https://n.maps.yandex.ru/). <br/> Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`. Если признак отсутствует, поля в ответе не будет.

#### 74
subscription.53
[sid](https://wiki.yandex-team.ru/passport/SIDs/): 53

Признак [подписки](SID_About.md) пользователя на [Яндекс.XML](https://xml.yandex.ru/settings/). <br/> Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`. Если признак отсутствует, поля в ответе не будет.

#### 75
subscription.54
[sid](https://wiki.yandex-team.ru/passport/SIDs/): 54

Признак [подписки](SID_About.md) пользователя на Яндекс.Музыку. <br/> Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`. Если признак отсутствует, поля в ответе не будет.

#### 76
subscription.55
[sid](https://wiki.yandex-team.ru/passport/SIDs/): 55

Признак [подписки](SID_About.md) пользователя на Мобильную почту. <br/> Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`. Если признак отсутствует, поля в ответе не будет.

#### 77
subscription.57
[sid](https://wiki.yandex-team.ru/passport/SIDs/): 57

Признак [подписки](SID_About.md) пользователя на [Кабинет разработчиков виджетов](https://wdgt.yandex.ru/widgets/). <br/> Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`. Если признак отсутствует, поля в ответе не будет.

#### 78
subscription.cloud.is_active
[sid](https://wiki.yandex-team.ru/passport/SIDs/): 59

Признак [подписки](SID_About.md) пользователя на Яндекс.Диск. <br/> Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`. Если признак отсутствует, поля в ответе не будет.

#### 79
subscription.60
[sid](https://wiki.yandex-team.ru/passport/SIDs/): 60

Признак [подписки](SID_About.md) пользователя на Партнерский интерфейс Новостей. <br/> Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`. Если признак отсутствует, поля в ответе не будет.

#### 80
subscription.cloud.is_paid
[sid](https://wiki.yandex-team.ru/passport/SIDs/): 64

Признак того, что у пользователя оплачен Яндекс.Диск.<br/> Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`. Если признак отсутствует, поля в ответе не будет.

#### 81
subscription.76
[sid](https://wiki.yandex-team.ru/passport/SIDs/): 76

Признак [подписки](SID_About.md) пользователя на Яндекс.Газету (сервис закрыт). <br/> Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`. Если признак отсутствует, поля в ответе не будет.

#### 82
subscription.cloud.use_mobile
[sid](https://wiki.yandex-team.ru/passport/SIDs/): 77

Признак пользователя мобильного Яндекс.Диска. <br/> Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`. Если признак отсутствует, поля в ответе не будет.

#### 83
subscription.78
[sid](https://wiki.yandex-team.ru/passport/SIDs/): 78

Признак [подписки](SID_About.md) пользователя на мобильную Яндекс.Музыку. <br/> Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`. Если признак отсутствует, поля в ответе не будет.

#### 84
subscription.cloud.use_desktop
[sid](https://wiki.yandex-team.ru/passport/SIDs/): 80

Признак пользователя десктопного Яндекс.Диска. <br/> Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`. Если признак отсутствует, поля в ответе не будет.

#### 85
subscription.cloud.use_web
[sid](https://wiki.yandex-team.ru/passport/SIDs/): 81

Признак пользователя веб-версии Яндекс.Диска. <br/> Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`. Если признак отсутствует, поля в ответе не будет.

#### 89
subscription.83
[sid](https://wiki.yandex-team.ru/passport/SIDs/): 83

Признак [подписки](SID_About.md) пользователя на [Мои Новости](https://yandex.ru/blog/company/69322) (возможность подписки на новости отключена). <br/> Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`. Если признак отсутствует, поля в ответе не будет.

#### 90
subscription.84
[sid](https://wiki.yandex-team.ru/passport/SIDs/): 84

Признак [подписки](SID_About.md) пользователя на кабинет разработчика приложений Яндекс.Store. <br/> Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`. Если признак отсутствует, поля в ответе не будет.

#### 91
subscription.85
[sid](https://wiki.yandex-team.ru/passport/SIDs/): 85

Признак [подписки](SID_About.md) пользователя на партнерский интерфейс дистрибуции.<br/> Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`. Если признак отсутствует, поля в ответе не будет.

#### 92
subscription.86
[sid](https://wiki.yandex-team.ru/passport/SIDs/): 86

Признак [подписки](SID_About.md) пользователя на публичные демо. Sid может использоваться для временных кампаний, промо-акций.<br/> Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`. Если признак отсутствует, поля в ответе не будет.

#### 95
subscription.88
[sid](https://wiki.yandex-team.ru/passport/SIDs/): 88

Признак [подписки](SID_About.md) пользователя на <q>живые письма</q> (сервис закрыт). <br/> Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`. Если признак отсутствует, поля в ответе не будет.

#### 96
subscription.90
[sid](https://wiki.yandex-team.ru/passport/SIDs/): 90

Признак [подписки](SID_About.md) пользователя на API Яндекс.Островов. <br/> Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`. Если признак отсутствует, поля в ответе не будет.

#### 97
subscription.91
[sid](https://wiki.yandex-team.ru/passport/SIDs/): 91

Признак [подписки](SID_About.md) пользователя на Почтовый офис. <br/> Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`. Если признак отсутствует, поля в ответе не будет.

#### 101
account.browser_key

Бинарный ключ, которым шифруются данные Браузера (история, пароли и т. д.).

❗️ Требует гранта.

#### 103
subscription.cloud.is_migrant
[sid](https://wiki.yandex-team.ru/passport/SIDs/): 93

Признак того, что данные пользователя были перенесены с Народа и Видео на Яндекс.Диск.<br/><br/> Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`. Если признак отсутствует, поля в ответе не будет.

#### 105
subscription.mailapp.2014 / subscription.94
[sid](https://wiki.yandex-team.ru/passport/SIDs/): 94

Признак [подписки](SID_About.md) пользователя на новое приложение Яндекс.Почты.<br/><br/> Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`. Если признак отсутствует, поля в ответе не будет.

#### 107
password.web_onlyaccount.enable_app_password

Признак того, что пользователь включил [пароли приложений](https://yandex.ru/support/passport/authorization/app-passwords.html).<br/><br/> Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`. Если признак отсутствует, поля в ответе не будет.

#### 108
subscription.video.search
[sid](https://wiki.yandex-team.ru/passport/SIDs/): 95

Признак [подписки](SID_About.md) пользователя на Видео-поиск.<br/><br/> Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`. Если признак отсутствует, поля в ответе не будет.

#### 109
subscription.bugbounty
[sid](https://wiki.yandex-team.ru/passport/SIDs/): 96

Признак того, что пользователь участвовал в [Охоте за ошибками](https://yandex.ru/support/passport/authorization/app-passwords.html).<br/><br/> Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`. Если признак отсутствует, поля в ответе не будет.

#### 112
subscription.avia
[sid](https://wiki.yandex-team.ru/passport/SIDs/): 97

Признак [подписки](SID_About.md) пользователя на Яндекс.Авиабилеты.<br/><br/> Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`. Если признак отсутствует, поля в ответе не будет.

#### 113
subscription.mailapp2014.androidphone
[sid](https://wiki.yandex-team.ru/passport/SIDs/): 201

Признак [подписки](SID_About.md) пользователя на новую мобильну почту для телефонов Android.<br/><br/> Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`. Если признак отсутствует, поля в ответе не будет.

#### 114
subscription.mailapp2014.androidtablet
[sid](https://wiki.yandex-team.ru/passport/SIDs/): 202

Признак [подписки](SID_About.md) пользователя на новую мобильну почту для планшетов Android. <br/> Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`. Если признак отсутствует, поля в ответе не будет.

#### 115
subscription.mailapp2014.iphone
[sid](https://wiki.yandex-team.ru/passport/SIDs/): 203

Признак [подписки](SID_About.md) пользователя на новую мобильну почту для iPhone. <br/> Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`. Если признак отсутствует, поля в ответе не будет.

#### 116
subscription.mailapp2014.ipad
[sid](https://wiki.yandex-team.ru/passport/SIDs/): 204

Признак [подписки](SID_About.md) пользователя на новую мобильну почту для iPad. <br/> Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`. Если признак отсутствует, поля в ответе не будет.

#### 117
subscription.mailapp2014.ipadbirdseye
[sid](https://wiki.yandex-team.ru/passport/SIDs/): 205

Признак [подписки](SID_About.md) пользователя на новую мобильну почту для iPad-Birdseye. <br/> Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`. Если признак отсутствует, поля в ответе не будет.

#### 119
subscription.kinopoisk
[sid](https://wiki.yandex-team.ru/passport/SIDs/): 98

Признак [подписки](SID_About.md) пользователя на Кинопоиск. <br/> Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`. Если признак отсутствует, поля в ответе не будет.

#### 120
subscription.realty
[sid](https://wiki.yandex-team.ru/passport/SIDs/): 73

Признак [подписки](SID_About.md) пользователя на Яндекс.Недвижимость. <br/> Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`. Если признак отсутствует, поля в ответе не будет.

#### 121
subscription.realty_agent
[sid](https://wiki.yandex-team.ru/passport/SIDs/): 106

Признак того, что пользователь является агентом на на Яндекс.Недвижимости.<br/> Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`. Если признак отсутствует, поля в ответе не будет.

#### 124
subscription.rabota
[sid](https://wiki.yandex-team.ru/passport/SIDs/): 72

Признак [подписки](SID_About.md) пользователя на [Яндекс.Работу](https://rabota.yandex.ru). <br/> Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`. Если признак отсутствует, поля в ответе не будет.

#### 125
subscription.rabota.employee
[sid](https://wiki.yandex-team.ru/passport/SIDs/): 108

Признак того, что пользователь является работником на сервисе Яндекс.Работа. <br/> Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`. Если признак отсутствует, поля в ответе не будет.

#### 126
subscription.rabota.blue_collar
[sid](https://wiki.yandex-team.ru/passport/SIDs/): 109

Признак того, что пользователь является <q>синим воротничком</q> на сервисе Яндекс.Работа. <br/> Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`. Если признак отсутствует, поля в ответе не будет.

#### 127
subscription.rabota.employer
[sid](https://wiki.yandex-team.ru/passport/SIDs/): 110

Признак того, что пользователь является работодателем на сервисе Яндекс.Работа. <br/> Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`. Если признак отсутствует, поля в ответе не будет.

#### 128
subscription.rabota.mobile_app
[sid](https://wiki.yandex-team.ru/passport/SIDs/): 111

Признак пользователя мобильного приложения Яндекс.Работа. <br/> Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`. Если признак отсутствует, поля в ответе не будет.

#### 129
subscription.rabota.mobile_site
[sid](https://wiki.yandex-team.ru/passport/SIDs/): 112

Признак пользователя мобильного сайта Яндекс.Работа. <br/> Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`. Если признак отсутствует, поля в ответе не будет.

#### 130
subscription.realty_moderator
[sid](https://wiki.yandex-team.ru/passport/SIDs/): 113

Признак модератора Яндекс.Недвижимости. <br/> Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`. Если признак отсутствует, поля в ответе не будет.

#### 131
subscription.taxi
[sid](https://wiki.yandex-team.ru/passport/SIDs/): 114

Признак [подписки](SID_About.md) пользователя на Яндекс.Такси. <br/> Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`. Если признак отсутствует, поля в ответе не будет.

#### 132
account.is_shared
[sid](https://wiki.yandex-team.ru/passport/SIDs/): 115

Признак совместного аккаунта, например - аккаунт таксопарка.<br/><br/> Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`. Если признак отсутствует, поля в ответе не будет.

#### 133
account.show_2fa_promo

Признак того, что пользователю будет показана промо-страница для включения двухфакторной авторизации после принудительной смены пароля.<br/><br/> Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`. Если признак отсутствует, поля в ответе не будет.

#### 137
subscription.realty.app.ios
[sid](https://wiki.yandex-team.ru/passport/SIDs/): 206

Пользователи iOS-приложения сервиса Яндекс.Недвижимость. <br/> Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`. Если признак отсутствует, поля в ответе не будет.

#### 138
subscription.realty.app.android
[sid](https://wiki.yandex-team.ru/passport/SIDs/): 207

Пользователи Android-приложения сервиса Яндекс.Недвижимость.<br/> Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`. Если признак отсутствует, поля в ответе не будет.

#### 139
subscription.site_search
[sid](https://wiki.yandex-team.ru/passport/SIDs/): 56

Признак [подписки](SID_About.md) пользователя на Яндекс.Поиск для сайта (ПДС).<br/> Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`. Если признак отсутствует, поля в ответе не будет.

#### 142
subscription.toloka
[sid](https://wiki.yandex-team.ru/passport/SIDs/): 116

Признак [подписки](SID_About.md) и использования Яндекс.Толоки. <br/> Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`. Если признак отсутствует, поля в ответе не будет.

#### 146
account.audience_on

Признак [подписки](SID_About.md) пользователя на Яндекс.Аудитории.<br/><br/> Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`. Если признак отсутствует, поля в ответе не будет.

#### 148
subscription.telephony
[sid](https://wiki.yandex-team.ru/passport/SIDs/): 117

Признак [подписки](SID_About.md) пользователя на Яндекс.Телефонию.<br/><br/> Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`. Если признак отсутствует, поля в ответе не будет.

❗️ Требует гранта.

#### 152
subscription.musicpremium
[sid](https://wiki.yandex-team.ru/passport/SIDs/): 208

Признак того, что пользователь однажды был подписан на Яндекс.Музыку и воспользовался пробным периодом. <br/> Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`. Если признак отсутствует, поля в ответе не будет.

#### 154
account.is_connect_admin

Признак администратора Яндекс.Коннекта. <br/> Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`. Если признак отсутствует, поля в ответе не будет.

#### 157
account.is_money_agreement_accepted

Признак того, что пользователь принял EULA Яндекс.Денег. <br/> Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`. Если признак отсутствует, поля в ответе не будет.

#### 166
account.creator_uid

Uid, для которого был создан колонкиш-аккаунт.

#### 169
takeout.extract_in_progress_since

Признак того, что аккаунт заказал выемку своих данных в Takeout, но она ещё не готова. Время начала выгрузки.

#### 172
takeout.archive_created_at

Таймстамп создания архива.

#### 173
takeout.fail_extract_at

Таймстамп, после которого выемка будет считаться сломанной.

#### 174
person.dont_use_displayname_as_public_name

Если выставлен этот атрибут, при вычислении public name не делать фолбек на display_name.

#### 176
subscription.drive
[sid](https://wiki.yandex-team.ru/passport/SIDs/): 118

Пользователь Яндекс.Драйв.

#### 178
investments.is_registered
[sid](https://wiki.yandex-team.ru/passport/SIDs/): 119

Пользователь Инвестиций.

#### 179
account.phonish_namespace

Идентификатор неймспейса, в котором живёт фониш.

#### 190
subscription.telemost
[sid](https://wiki.yandex-team.ru/passport/SIDs/): 121

Пользователь пользуется телемостом.

#### 197
subscription.mailpro
[sid](https://wiki.yandex-team.ru/passport/SIDs/): 122

Подписка на Почту Про.

#### 200
account.sms_2fa_on

Включённость 2фа через смс (обязательный смсный челленж при входе с нового устройства).

#### 202
account.content_rating_class

Класс возрастных ограничений ребёнкиша на контент.

#### 203
subscription.mail.status
[sid](https://wiki.yandex-team.ru/passport/SIDs/): 2

Состояние почтового ящика: 1 - активен, 2 - заморожен.

#### 210
account.is_child

Признак детского аккаунта.

#### 212
person.firstname_global

Имя пользователя на английском (аналог 27 атрибута).

❗️ Требует гранта.

#### 213
person.lastname_global

Фамилия пользователя на английском (аналог 28 атрибута).

❗️ Требует гранта.

#### 215
account.bank_subscription
[sid](https://wiki.yandex-team.ru/passport/SIDs/): 125

Подписка на Я.Банк.

#### 219
account.is_documents_agreement_accepted

Согласие на передачу документов из / в ID.

#### 223
account.dzen_sso_prohibited

Булевый флаг. 1, если пользватель явно сообщил: "Забудьте меня на zen".

#### 1001
person.birthday

Месяц и день рождения пользователя.

❗️ Требует гранта.

#### 1002
person.birthyear

Год рождения пользователя.

❗️ Требует гранта.

#### 1003
account.2fa_on

Признак включенной двухфакторной аутентификации. <br/> Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`. Если признак отсутствует, поля в ответе не будет.

#### 1005
account.have_password

Признак наличия у пользователя пароля, обычного или двухфакторного.<br/> Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`. Если признак отсутствует, поля в ответе не будет.

#### 1006
account.have_hint

Признак наличия у пользователя секретного вопроса и ответа для восстановления доступа.

#### 1007
person.fio

Фамилия и имя пользователя.

❗️ Требует гранта.

#### 1008
account.normalized_login

Нормализованный логин пользователя.

#### 1009
account.is_available

Высокоуровневый признак доступности аккаунта , учитывающий свойство account.is_disabled на аккаунте и domain.enabled на домене. <br/> Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`. Если признак отсутствует, поля в ответе не будет.

#### 1011
account.have_organization_name

Признак того, что у пользователя ПДД указано название организации.<br/><br/> Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`. Если признак отсутствует, поля в ответе не будет.

#### 1013
account.security_level

Степень защищенности аккаунта пользователя.

#### 1014
account.rfc_2fa_on

Признак того, что у пользователя включена двухфакторная аутентификации при помощи [RFC TOTP](https://ru.wikipedia.org/wiki/Time-based_One-time_Password_Algorithm). Атрибут используется только во [внутреннем ЧЯ](https://docs.yandex-team.ru/blackbox/concepts/location#section_internal).<br/><br/> Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`. Если признак отсутствует, поля в ответе не будет.
1015
account.have_plus | Признак того, что у пользователя включена подписка на Яндекс.Плюс.<br/><br/> Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`. Если признак отсутствует, поля в ответе не будет.|
#### 1016
account.kinopoisk_ott_subscription_name

Строка с именем подписки на Кинопоиск.

#### 1017
account.connect_organization_ids

Список идентификаторов организаций, которым принадлежит аккаунт.

#### 1018
account.plus_trial_used_ts

Timestamp начала использования пробного периода Яндекс.Плюса.

#### 1019
account.plus_subscription_stopped_ts

Timestamp остановки подписки Плюса.

#### 1020
account.plus_subscription_expire_ts

Timestamp конца подписки Плюса.

#### 1021
account.plus_next_charge_ts

Timestamp следующего списания денег на Яндекс.Плюс.

#### 1022
account.plus_family_role

Роль в семейной подписке на Плюс.

#### 1023
account.suggest_public_name

UGC-сервис может предложить пользователю поменять подпись.<br/><br/>Для того, чтобы сокращенная фамилия в подписях UGC превратилась в полную. Вариант display_name.public_name с полной фамилией будет находиться в значении атрибута. Если атрибута нет, предлагать пользователю нельзя.

❗️ Требует гранта.

#### 1024
account.has_сustom_publicid

"1", если у пользователя уже выбран человекопонятный publicid.

#### 1025
account.has_plus_cashback

"1", если account.plus.cashback_enabled существует и не пуст.

#### 1026
account.music_content_rating_klass

Класс возрастных ограничений ребёнкиша на музыкальный контент.

#### 1027
account.video_content_rating_klass

Класс возрастных ограничений ребёнкиша на видео контент.

#### 1028
account.plus.mapped_subscription_level

Приведенное значение уровня подписки плюс (account.plus.subscription_level).<br/><br/>[10; 19] -> "1",<br/>[20; 29] -> "2",<br/>[30; 39] -> "3",<br/>[40; 49] -> "4"

#### 1029
account.family_pay

"1", если пользователь может платить семейной картой.

#### 1030
account.plus.is_frozen

Признак заморозки подписки плюс.

#### 1031
account.org_id

id организации, к которой принадлежит домен (ПДД/Коннект/Почта360).

#### 1032
account.reg_completion_recommended

Признак необходимости дорегистрации для неофонишей.

#### 1033
account.is_kid

Пользователь является детским профилем (не путать с детским акаунтом - is_child - аттр 210).

#### 1034
account.family_children_management

"1", если у пользователя есть право в семье на "управление детьми".

## Телефонные атрибуты {#section_kbk_b5f_2hb}

Чтобы получить значения телефонных атрибутов, используйсте параметры `getphones=<all|bound>` и `phone_attributes=<тип_атрибута_1>,<тип_атрибута_2>,...` в [запросах к ЧЯ](https://docs.yandex-team.ru/blackbox/methods/userinfo#request_format).

Тип | Имя | Значение
----- | ----- | -----
1 | phone.number | Номер телефона. <br/>❗️ Требует гранта.
2 | phone.created | Время создания записи. <br/>❗️ Требует гранта.
3 | phone.bound | Время привязки телефона к аккаунту. <br/>❗️ Требует гранта.
4 | phone.confirmed | Время подтверждения владения номером. <br/>❗️ Требует гранта.
5 | phone.admitted | Время подтверждения пользователем владения номером (варианты: approved, conceded, accepted, agreed). <br/>❗️ Требует гранта.
6 | phone.secured | Время получения статуса защищённости номера. <br/>❗️ Требует гранта.
101 | phone.formatted_number | Номер в international формате `(+7 999 111-22-33)`. <br/>❗️ Требует гранта.
102 | phone.e164_number | Номер в e164 `(+79991112233)`. <br/>❗️ Требует гранта.
103 | phone.masked_formatted_number | Форматированный маскированный номер `(+7 999 ***‒**‒33)`.
104 | phone.masked_e164_number | Маскированный номер в e164 `  (+7999*****33)`.
105 | phone.is_confirmed | Булевский флаг: подтвержден ли номер.<br/>`1`, если пользователь ввёл проверочный код, который был отправлен на данный телефон.
106 | phone.is_bound | Булевский флаг: привязан ли номер.<br/>`1`, если пользователь так или иначе связал данный телефон со своим аккаунтом (на данный момент привязанность влечёт за собой подтвержденность)
107 | phone.is_default | Булевский флаг: дефолтный ли номер.<br/>`1`, если данный телефон следует использовать для общения с пользователем.
108 | phone.is_secured | Булевский флаг: защищен ли номер.<br/>`1`, если данный телефон используется для восстановления доступа к аккаунту. Одновременно может быть только один защищенный номер.
109 | phone.is_bank | Булевский флаг: является ли номер банковским


## Почтовые атрибуты {#section_gyv_v5f_2hb}

Чтобы получить значения почтовых атрибутов, используйсте параметры `getemails=all` и `email_attributes=<тип_атрибута_1>,<тип_атрибута_2>,...` в [запросах к ЧЯ](https://docs.yandex-team.ru/blackbox/methods/userinfo#request_format).

Тип | Имя | Значение
----- | ----- | -----
1 | email.address | Внешний адрес электронной почты.
2 | email.created | Время создания email'а.
3 | email.confirmed | Время подтверждения email'а.
4 | email.bound | Время привязки email'а.
5 | email.is_rpop | Сборщик писем.
6 | email.is_unsafe | Запрет использования почтового ящика для восстановления пароля.
7 | email.is_silent | Запрет рассылок и нотификаций на email.

## accounts (информация об учетных записях) {#accounts}

Что хранится | Как записывается | Как прочитать
----- | ----- | -----
UID — уникальный идентификатор учетной записи. Каждая зарегистрированная учетная запись получает новый UID вне зависимости от ее типа. | UID записывается только при создании учетной записи. | Значение поля всегда возвращается в положительном ответе методов Черного ящика [login](https://doc.yandex-team.ru/blackbox/reference/MethodLogin.dita), [sessionid](https://doc.yandex-team.ru/blackbox/reference/MethodSessionID.xml), [userinfo](https://doc.yandex-team.ru/blackbox/reference/MethodUserInfo.xml) и [oauth](https://doc.yandex-team.ru/blackbox/reference/method-oauth.xml). в элементе `uid`.
Логин — логин учетной записи Яндекса. Содержимое этого поля формируется различным образом для учетных записей разных типов:<br/><br/>- Для полноценных аккаунтов поле содержит логин, заданный пользователем при регистрации. Хранится нормализованным: в логине, который задал пользователь, точки заменяются на дефисы, а заглавные буквы заменяются на строчные.<br/>    <br/>- Для лайт-аккаунтов подписка на SID 33) зафиксированы следующие значения:    <br/>   поле содержит e-mail, использованный при регистрации.<br/>    <br/>- Для учетных записей ПДД поле содержит e-mail пользователя.<br/>    <br/>- Для аккаунтов, регистрируемых через социальную сеть, Паспорт генерирует случайный логин вида `uid-werysyd` для обратной совместимости. | Логин учетной записи записывается:<br/><br/>- при регистрации в режиме [register](https://doc.yandex-team.ru/Passport/passport-modes/reference/register.html);<br/>- при выборе логина для социального аккаунта в режиме [postregistration](https://doc.yandex-team.ru/Passport/passport-modes/reference/postregistration.html). | Значение поля можно запросить с помощью методов Черного ящика [login](https://doc.yandex-team.ru/blackbox/reference/MethodLogin.dita), [sessionid](https://doc.yandex-team.ru/blackbox/reference/MethodSessionID.xml), [userinfo](https://doc.yandex-team.ru/blackbox/reference/MethodUserInfo.xml) и [oauth](https://doc.yandex-team.ru/blackbox/reference/method-oauth.xml), указав параметр `attributes` со значением 1008.<br/><br/>Логин таким, каким его ввел пользователь, возвращается в ответе этих методов по умолчанию, в элементе `login`.
Карма — показатель того, что учетная запись подозревается в рассылке спама или была зарегистрирована автоматически (см. раздел [Карма](accounts-attributes.md#karma)). | Карма назначается при регистрации Фродообороной и может быть изменена с помощью режима Паспорта [admkarma](https://doc.yandex-team.ru/Passport/passport-modes/reference/admkarma.html). | Значение поля возвращается по умолчанию в ответе методов Черного ящика [login](https://doc.yandex-team.ru/blackbox/reference/MethodLogin.dita), [sessionid](https://doc.yandex-team.ru/blackbox/reference/MethodSessionID.xml), [userinfo](https://doc.yandex-team.ru/blackbox/reference/MethodUserInfo.xml) и [oauth](https://doc.yandex-team.ru/blackbox/reference/method-oauth.xml), в элементе `karma`.

## userinfo (личные данные пользователей) {#userinfo}

Что хранится | Как записывается | Как прочитать
----- | ----- | -----
Имя пользователя. | Пользователь вводит имя при регистрации. После регистрации имя можно изменить с помощью режима [changereg](https://doc.yandex-team.ru/Passport/passport-modes/reference/changereg.html). | Значение поля следует запрашивать с помощью аргумента `dbfields` одного из методов Черного ящика — [login](https://doc.yandex-team.ru/blackbox/reference/MethodLogin.dita), [sessionid](https://doc.yandex-team.ru/blackbox/reference/MethodSessionID.xml), [userinfo](https://doc.yandex-team.ru/blackbox/reference/MethodUserInfo.xml) или [oauth](https://doc.yandex-team.ru/blackbox/reference/method-oauth.xml).<br/><br/>Пример значения параметра: `dbfields=userinfo.firstname.uid`.
Фамилия пользователя. | Пользователь вводит фамилию при регистрации. После регистрации фамилию можно изменить с помощью режима [changereg](https://doc.yandex-team.ru/Passport/passport-modes/reference/changereg.html). |  [DB_About-standard-read](../_includes/concepts/DB_About/id-DB_About/standard-read.md) <br/><br/><br/>Пример параметра: `dbfields=userinfo.lastname.uid`.
Имя пользователя для отображения в интерфейсе.<br/><br/>Отображаемым именем для пользователя может быть:<br/>- логин в Яндексе;<br/>- имя или имя и фамилия, введенные при регистрации в Яндексе;<br/>- имя из [социального профиля](accounts-attributes.md#social-profile). | Отображаемое имя определяется при регистрации. | Значение поля следует запрашивать с помощью аргумента `regname` одного из методов Черного ящика — [login](https://doc.yandex-team.ru/blackbox/reference/MethodLogin.dita), [sessionid](https://doc.yandex-team.ru/blackbox/reference/MethodSessionID.xml), [userinfo](https://doc.yandex-team.ru/blackbox/reference/MethodUserInfo.xml) или [oauth](https://doc.yandex-team.ru/blackbox/reference/method-oauth.xml).<br/><br/>ЧЯ возвращает отображаемое имя в элементе `display_name`.
Пол пользователя. Возможные значения:<br/>- 0 — пол не указан;<br/>- 1 — мужской;<br/>- 2 — женский. | Пользователь указывает пол при регистрации. После регистрации пол можно изменить с помощью режима [changereg](https://doc.yandex-team.ru/Passport/passport-modes/reference/changereg.html). |  [DB_About-standard-read](../_includes/concepts/DB_About/id-DB_About/standard-read.md) <br/><br/><br/>Пример параметра: `dbfields=userinfo.sex.uid`.
Дата рождения пользователя в формате «YYYY-MM-DD». Поля, не указанные при записи, заполняются нулями, например «0000-00-12».<br/><br/>При записи проверяется только корректность количества цифр, поэтому в базе могут оказаться несуществующие даты, например «2012-12-43». | Пользователь указывает дату рождения при регистрации. После регистрации дату рождения можно изменить с помощью режима [changereg](https://doc.yandex-team.ru/Passport/passport-modes/reference/changereg.html). |  [DB_About-standard-read](../_includes/concepts/DB_About/id-DB_About/standard-read.md) <br/><br/><br/>Пример параметра: `dbfields=userinfo.birth_date.uid`.
Страна проживания пользователя. | Паспорт определяет местоположение пользователя при регистрации.<br/><br/>После регистрации страну можно изменить с помощью режима [changereg](https://doc.yandex-team.ru/Passport/passport-modes/reference/changereg.html). |  [DB_About-standard-read](../_includes/concepts/DB_About/id-DB_About/standard-read.md) <br/><br/><br/>Пример параметра: `dbfields=userinfo.country.uid`.
Дата и время регистрации пользователя в Паспорте в формате «YYYY-MM-DD HH:MM:SS». | Время фиксируется при регистрации и не может быть изменено впоследствии. |  [DB_About-standard-read](../_includes/concepts/DB_About/id-DB_About/standard-read.md) <br/><br/><br/>Пример параметра: `dbfields=userinfo.reg_date.uid`.
Язык интерфейса для пользователя. Сервисы должны запрашивать значение этого поля, чтобы определять нужный язык интерфейса с помощью библиотеки [lang-detect](https://doc.yandex-team.ru/lib/lang-detect/concepts/about.html). | Паспорт определяет предпочитаемый пользователем язык интерфейса при регистрации. |  [DB_About-standard-read](../_includes/concepts/DB_About/id-DB_About/standard-read.md) <br/><br/><br/>Пример параметра: `dbfields=userinfo.lang.uid`.


## subscription (данные о подписках на сервисы) {#subscription-table}

Что хранится | Как записывается | Как прочитать
----- | ----- | -----
Идентификатор учетной записи на сервисе (SUID). SUID уникален для сервиса, в паре с SID однозначно идентифицирует аккаунт.<br/><br/>Все зарегистрированные SID перечислены на странице вики [Cписок SID`ов паспорта](http://wiki.yandex-team.ru/passport/SIDs). | SUID генерируется при подписке на сервис и не может быть изменен впоследствии. |  [DB_About-standard-read](../_includes/concepts/DB_About/id-DB_About/standard-read.md) <br/><br/><br/>Пример параметра:<br/>``` dbfields=subscription.suid.2 ```
Логин пользователя на сервисе. Для сервисов Почта и Народ, а также на почте @narod.ru значение этого поля может отличаться от [логина в таблице `accounts`](#login). | Логин подписки изменить нельзя. |  [DB_About-standard-read](../_includes/concepts/DB_About/id-DB_About/standard-read.md) <br/><br/><br/>Пример параметра:<br/>``` dbfields=subscription.login.2 ```
Характеристика подписки. Целое число, которое сервис может выставлять и интерпретировать по своему усмотрению. Обычно поле используется для хранения набора флагов, характеризующих подписку (например, значение «0» указывает на то, что сервис недоступен учетной записи).<br/><br/>Например, для описания лайт-аккаунтов (подписка на SID 33) зафиксированы следующие значения:<br/>- 1 — пользователь сам указал пароль при регистрации лайт-аккаунта;<br/>- 2 — пользователь оставил пароль, автоматически сгенерированный при регистрации лайт-аккаунта;<br/>- 3 — пользователь дорегистрировался, и лайт-аккаунт стал полноценной учетной записью Яндекса. | При создании подписки значение поля равно 0.<br/><br/>После создания подписки поле можно изменить с помощью режима [admloginrule](https://doc.yandex-team.ru/Passport/passport-modes/reference/admloginrule.html). |  [DB_About-standard-read](../_includes/concepts/DB_About/id-DB_About/standard-read.md) <br/><br/><br/>Пример параметра:<br/>``` dbfields=subscription.login_rule.33 ```
