# Защита от роботов и подбора пароля

Система авторизации следует [политике защиты от подбора паролей](https://doc.yandex-team.ru/blackbox/concepts/blackboxPwdPolicy.xml), описанной в документе [Программный интерфейс сервиса Яндекс.blackbox](https://doc.yandex-team.ru/blackbox/concepts/about.xml).

## Защита сервисов без веб-интерфейса {#noweb}

Сервисы без веб-интерфейса проверяют логины и пароли с помощью метода Черного ящика [login](https://doc.yandex-team.ru/blackbox/reference/MethodLogin.xml).

Защита таких сервисов от подбора паролей полностью основана на политике Черного ящика.

## Защита веб-сервисов {#web}

Веб-сервисы проверяют логины и пароли с помощью Паспорта. Паспорт, в свою очередь, проверяет пароли с помощью ЧЯ — таким образом применяется политика защиты.

Автоматический подбор пароля в веб-интерфейсе также ограничивается с помощью капчи. Использование капчи зависит от используемого режима авторизации:

- [auth](https://doc.yandex-team.ru/Passport/passport-modes/reference/auth.html) (авторизация на странице Паспорта).

    Паспорт выводит капчу, если пользователь несколько раз вводит неправильный пароль.

- [embeddedauth](https://doc.yandex-team.ru/Passport/passport-modes/reference/embeddedauth.html) (авторизация на странице сервиса).

    Сервис должен показывать капчу согласно ответу Паспорта.

    Для показа и проверки капчи предназначен Капча-сервер (описан в документе [API капча-сервера. Руководство разработчика](https://doc.yandex-team.ru/Passport/captcha/concepts/about.xml)).


{% note info %}

Некоторые операции (например, смена пароля) требуют ввода пароля независимо от авторизации. Такие проверки можно производить с помощью метода Черного ящика [login](https://doc.yandex-team.ru/blackbox/reference/MethodLogin.xml).

{% endnote %}


