# Обновление авторизационной куки

Сервис должен запрашивать и выставлять новые авторизационные куки, если срок жизни кук пользователя близок к концу.

Признак того, что куку нужно обновить, возвращает метод Черного ящика [sessionid](https://doc.yandex-team.ru/blackbox/reference/MethodSessionID.xml): в поле ответа `status` проставляется значение `NEED_RESET`. При любом другом значении статуса куку обновлять не следует.

Ниже приведены различные способы обновления куки, и общие сведения о сроке жизни авторизационных кук.

Для мультидоменной авторизации обновление куки описано на [Вики](https://wiki.yandex-team.ru/passport/sso/#kakispolzovat).

## Срок жизни авторизационной куки {#renew_2}

Срок жизни куки зависит от условий авторизации:

Вид куки | Срок жизни | Условия выставления
----- | ----- | -----
Постоянная | Принимается в течение трех месяцев после последнего запроса пользователя с этой кукой. | Выставляется по умолчанию, если пользователь не запрашивает сессионную куку.
Сессионная | Принимается в течение двух часов после последнего запроса пользователя с этой кукой. | Пользователь явно запросил сессионную куку (например, отметив при авторизации флажок **чужой компьютер**).<br/><br/>Чтобы выставить сессионную куку, сервис должен вызвать режим [auth](https://doc.yandex-team.ru/Passport/passport-modes/reference/auth.html) или [embeddedauth](https://doc.yandex-team.ru/Passport/passport-modes/reference/embedded.html) с соответствующим параметром.


Все авторизационные куки перестают быть валидными по истечении срока жизни или после глобального разлогинивания (ссылка **Выйти на всех компьютерах** в Паспорте, параметр `global` режима Паспорта [logout](https://doc.yandex-team.ru/Passport/passport-modes/reference/logout.html)).

## Обновление с редиректом на Паспорт {#renew}

Сервис явно редиректит пользователя на Паспорт, который выставляет новую куку (и, опционально, возвращает пользователя на заданный в редиректе адрес).

Последовательность действий:

1. Фронтенд сервиса проверяет авторизационную куку с помощью Черного ящика и получает статус `NEED_RESET`.
1. Сервис перенаправляет пользователя по адресу, составленному следующим образом:
    ```no-highlight
    https://passport.yandex[-team].<TLD>/auth/update/?retpath=<обратная ссылка, urlencoded>
    ```

1. Паспорт выставляет обновленную авторизационную куку.
1. Если адрес, указанный в параметре `retpath`, является корректным URL и ведет на домен Яндекса, Паспорт перенаправляет пользователя по этому адресу. В противном случае пользователь остается на [главной странице Паспорта](https://passport.yandex.ru).

## Обновление AJAX-запросом {#renew_1}

Скрипт сервиса запрашивает новую куку у Паспорта и получает заголовок `Set-Cookie` с новой авторизационной кукой (и остальными куками для данного домена).

1. Фронтенд сервиса проверяет авторизационную куку с помощью Черного ящика и получает статус `NEED_RESET`.
1. Фронтенд сервиса передает статус куки в браузерный скрипт.
1. Скрипт запрашивает новую авторизационную куку по следующему адресу:
    ```no-highlight
    https://passport.yandex[-team].<TLD>/auth/update/
    ```

1. Паспорт возвращает ответ, который включает заголовок `Set-Cookie` со всеми куками для запрошенного домена, флагом `HttpOnly` и телом ответа `{status: "ok"}`.

## Поллинг статуса куки в iframe {#renew_3}

Сервис открывает iframe, который периодически передает текущую авторизационную куку на проверку в Паспорт. Как только кука начинает требовать обновления, Паспорт возвращает заголовок `Set-Cookie` с новой авторизационной кукой (и остальными куками для данного домена).

1. Скрипт, запущенный в iframe, периодически отправляет текущую авторизационную куку на проверку по следующему адресу:
    ```no-highlight
    https://passport.yandex[-team].<TLD>/auth/update/
    ```

1. Как только Паспорт получает куку, которую стоит обновить, он возвращает ответ с заголовком `Set-Cookie`, в который включается новая авторизационная кука (и остальные куки для данного домена), флаг `HttpOnly` и тело ответа `{status: "ok"}`.

