# Обработка авторизационных кук

Основная функция системы авторизации — выставление авторизационных кук по запросу сервисов Яндекса. Сервисы должны обрабатывать авторизационные куки пользователей согласно определенному алгоритму.

Упрощенный алгоритм рассмотрен на примере веб-сервиса, для которого предполагается следующее:

- Пользователь авторизуется с помощью логина и пароля.
- При неудавшейся авторизации пользователь повторно вводит логин и пароль.

Представленный алгоритм описывает путь от запроса страницы сервиса до получения персонализированной страницы:

![image](../_assets/user-auth.png)

1. Пользователь запрашивает страницу сервиса с помощью браузера. Запрос содержит авторизационные куки, если они выставлены в данном браузере.

    Обработка запроса зависит от наличия авторизационных кук:

    - Если запрос не содержит авторизационные куки, или переданные куки невалидны, сервис должен предложить пользователю авторизоваться. Например, вывести [домик авторизации](interface.md). (Переход к [шагу 2](#2).)
    - Если запрос содержит [авторизационную куку](https-sessionid.md), сервис должен проверить ее. (Переход к [шагу 5](#5).)

1. Пользователь вводит логин и пароль на сервисе. (Особенности такой аутентификации описаны в разделе [Защита от роботов и подбора пароля](authentication-policy.md).)

1. Сервис проверяет логин и пароль с помощью Паспорта (в режиме [`auth`](https://doc.yandex-team.ru/Passport/passport-modes/reference/auth.html) или [`embeddedauth`](https://doc.yandex-team.ru/Passport/passport-modes/reference/embeddedauth.html)).

    Дальнейшие действия зависят от результата проверки:

    - Если аутентификация неуспешна, Паспорт сообщит об ошибке и предложит ввести логин и пароль еще раз. (Переход к [шагу 2](#2).)
    - Если аутентификация успешна, Паспорт выставляет пользователю авторизационные куки и возвращает пользователя на сервис. (Переход к [шагу 4](#4).)

1. После успешной аутентификации Паспорт выставляет авторизационные куки и возвращает пользователя на сервис. (Переход к [шагу 1](#1).)

1. Сервис проверяет авторизационные куки, извлеченные из запроса, с помощью метода Черного ящика [`sessionid`](https://doc.yandex-team.ru/blackbox/reference/MethodSessionID.xml). Обработка запроса зависит от результата проверки:

    - Если куки невалидны, сервис должен предложить пользователю авторизоваться повторно. (Переход к [шагу 2](#2).)
    - Если куки валидны, сервис должен вернуть пользователю персонализированную страницу. (Переход к [шагу 6](#6).)

1. В ответ на запрос с валидными авторизационными куками сервис должен вернуть персонализированную страницу.

1. Если куки [нуждаются в обновлении](authorization-policy-resign.md#renew), сервис должен должен вернуть персонализированную страницу и выставить продленные авторизационные куки.


