# Авторизация по протоколу HTTPS

Куку `Session_id` злоумышленник может перехватить при передаче по протоколу HTTP. Для дополнительной защиты сессии можно использовать куку `sessionid2`, выставляемую по HTTPS.

Кука `sessionid2` выставляется при следующих условиях:

- успешно выставлена кука `Session_id`;
- пользователь авторизовался с помощью логина и пароля (
    {% cut "социальная авторизация" %}

    Авторизация пользователя с помощью учетной записи внешнего социального сервиса (Facebook, Twitter и т. д.). Связь с внешними сервисами обеспечивает Социализация, описанная в соответствующем кластере Вики: [http://wiki.yandex-team.ru/social](http://wiki.yandex-team.ru/social).

    {% endcut %}

    не может быть защищена);
- логин и пароль были введены на HTTPS-странице.

Чтобы проверить, защищена ли сессия пользователя, пару авторизационных кук необходимо проверять в совокупности.

## Проверка пары авторизационных кук

Обе авторизационные куки проверяются одним и тем же методом Черного ящика [sessionid ](https://doc.yandex-team.ru/blackbox/reference/MethodSessionID.xml). Если обе куки выставлены, рекомендуется передавать Черному ящику оба значения, не проводя дополнительных проверок на стороне сервиса.

Ответ метода `sessionid` содержит один из трех результатов проверки:

Результат | Следствие
----- | -----
Кука `Session_id` невалидна или просрочена (значение `sessionid2` при этом не проверяется). | Пользователь не авторизован в рамках данной сессии.
Кука `Session_id` валидна, `sessionid2` — невалидна. | Пользователь авторизован в течение HTTP-сессии.<br/><br/>Если для работы с запрошенной страницей необходима защищенная сессия, сервис может попросить пользователя ввести пароль еще раз, по HTTPS-протоколу.
Обе куки выписаны для одной учетной записи и валидны. | Пользователь авторизован в течение HTTPS-сессии.


